#include <iostream>
#include <vector>
#include <cmath>
#include <climits>
#define ff first
#define ss second

using namespace std;
typedef long double dbl;

const dbl pi = acosl(-1);
const dbl eps = 1e-12;

dbl a[6];

bool leq(dbl x, dbl y) {
    return x < y || abs(x - y) < eps;
}

bool leq(dbl x, dbl y, dbl z) {
    return leq(x, y) && leq(y, z);
}

bool check(dbl phi) {
    return leq(a[0], phi, a[1]) || leq(a[2], phi, a[3]) || leq(a[4], phi, a[5]);
}

dbl sq(dbl x, dbl y, dbl z) {
    dbl p1 = y - x, p2 = z - y, p3 = x - z;
    return abs(sinl(p1) + sinl(p2) + sinl(p3));
}

dbl mod(dbl p) {
    while (p < 0) p += pi * 2;
    //while (leq(pi * 2, p)) p -= pi * 2;
    while (pi * 2 < p) p -= pi * 2;
    return p;
}

int main() {
    cout.precision(20);

    dbl r; cin >> r;
    for (int i = 0; i < 6; ++i) cin >> a[i];
    dbl ans = 0;
    for (int i = 0; i < 6; ++i)
        for (int j = i + 1; j < 6; ++j)
            for (int k = j + 1; k < 6; ++k)
                ans = max(ans, sq(a[i], a[j], a[k]));
    
    for (int i = 0; i < 6; ++i)
        for (int j = i + 1; j < 6; ++j) {
            dbl phi1 = (a[i] + a[j]) / 2;
            dbl phi2 = mod(phi1 - pi);
            if (check(phi1))
                ans = max(ans, sq(a[i], a[j], phi1));
            if (check(phi2))
                ans = max(ans, sq(a[i], a[j], phi2));
        }

    for (int i = 0; i < 6; ++i) {
        dbl phi1 = mod(a[i] + pi * 2. / 3.);
        dbl phi2 = mod(a[i] - pi * 2. / 3.);
        if (check(phi1) && check(phi2))
            ans = max(ans, sq(a[i], phi1, phi2));
    }

    cout << ans * (r * r) / 2.0 << "\n";
}