#include <iostream>
#include <string>
#include <vector>
#include <deque>
#include <queue>
#include <stack>
using namespace std;
#define int long long

int gcd(int a, int b) {
    if (a == 0 || b == 0)
        return a + b;
    if (a > b)
        return gcd(a % b, b);
    return gcd(b % a, a);
}

struct song{
    int start, len;
    string name;
    song(int st = 0, int l = 0, string nm = "") {
        start = st;
        len = l;
        name = nm;
    }
};

signed main() {
#ifdef LOCAL
    freopen("in.txt", "r", stdin);
    freopen("out.txt", "w", stdout);
#endif
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr); cout.tie(nullptr);

    int n, t = 0; cin >> n;
    deque<song> d;
    for (int i = 0; i < n; i++) {
        int l;
        string nm;
        cin >> nm >> l;
        d.push_back(song(-1, l, nm));
    }

    queue<song> q;
    int m; cin >> m;
    for (int i = 0; i < n; i++) {
        int st, l;
        string nm;
        cin >> st >> nm >> l;
        q.push(song(st, l, nm));
    }

    while(q.size() > 0 || d.size() > 0) {
        song sng(0, 0, "");
        if (d.size() > 0) {
            sng = d.front();
            d.pop_front();
        } else {
            sng = q.front();
            q.pop();
            t = sng.start;
        }
        cout << sng.name << ' ' << t << endl;
        t += sng.len;
        while (q.size() > 0 && q.front().start < t) {
            d.push_back(q.front());
            q.pop();
        }
        while (q.size() > 0 && q.front().start == t) {
            d.push_front(q.front());
            q.pop();
        }
    }
}