#include <iostream>
#include <deque>
#include <algorithm>
using namespace std;
using ll = long long;

struct event {
	string name;
	ll len;
};

struct nxt {
	ll t;
	string name;
	ll len;
};

void solve() {
	int n;
	cin >> n;
	deque<event> d;
	for (int i = 0; i < n; i++) {
		event x;
		cin >> x.name >> x.len;
		d.push_back(x);
	}
	int m;
	cin >> m;
	deque<nxt> dn;
	for (int j = 0; j < m; j++) {
		nxt dx;
		cin >> dx.t >> dx.name >> dx.len;
		dn.push_back(dx);
	}
	ll timer = 0;
	while (!d.empty()) {
		while (!dn.empty() && dn.front().t <= timer) {
			event cur;
			cur.name = dn.front().name;
			cur.len = dn.front().len;
			d.push_front(cur);
			dn.pop_front();
		}
		cout << d.front().name << " " << timer << "\n";
		timer += d.front().len;
		d.pop_front();
	}
	deque<nxt> ans;
	while (!dn.empty()) {
		ans.push_front(dn.front());
		dn.pop_front();
	}
	while (!ans.empty()) {
		timer = max(timer, ans.front().t);
		cout << ans.front().name << " " << timer << "\n";
		timer += ans.front().len;
		ans.pop_front();
	}
}

int main() {
	ios::sync_with_stdio(false);
	cin.tie(nullptr);
	solve();
}