#include <iostream>
#include <algorithm>
#include <vector>
#include <set>
#include <random>

using ll = long long;
using namespace std;
mt19937 rnd(141);

bool check(int n, vector <vector <int>>& a) {
	set <int> s;
	for (int i = 0; i < n; i++) if (a[i][i] != i + 1) return false;
	for (int i = 0; i < n; i++) {
		s.clear();
		for (auto j : a[i]) s.insert(j);
		if ((int)s.size() < n) return false;
	}
	for (int j = 0; j < n; j++) {
		s.clear();
		for (int i = 0; i < n; i++) s.insert(a[i][j]);
		if ((int)s.size() < n) return false;
	}
	return true;
}

void print(vector <vector <int>>& a) {
	for (auto& i : a) {
		for (auto j : i) cout << j << " ";
		cout << "\n";
	}
	exit(0);
}

signed main() {
	ios::sync_with_stdio(0);
	cin.tie(0); cout.tie(0);

	int n, x, y; cin >> n;
	if (n % 2 == 1) {
		vector <vector <int>> a(n, vector <int>(n, -1));
		for (int i = 0; i < n / 2; i++) {
			x = 0; y = 2 * i;
			while (y >= 0) a[x++][y--] = i;
			x = 2 * i + 1; y = n - 1;
			while (x < n) a[x++][y--] = i;
		}
		for (int i = 0; i < n; i++) a[i][n - i - 1] = n / 2;
		for (int i = n - 1; i > n / 2; i--) {
			x = 2 * i - n + 1; y = n - 1;
			while (x < n) a[x++][y--] = i;
			x = 0; y = 2 * i - n;
			while (y >= 0) a[x++][y--] = i;
		}
		for (int i = 0; i < n; i++) {
			for (int j = 0; j < n; j++) cout << a[i][j] + 1 << " ";
			cout << "\n";
		}
		return 0;
	}
	vector <vector <int>> a(n, vector <int>(n));
	for (int i = 0; i < n; i++) {
		for (int j = 0; j < n; j++) {
			a[i][j] = i + 1;
		}
	}
	int x1, x2, y1, y2;
	for (int iter = 0; iter <= 100000; iter++) {
		if (check(n, a)) print(a);
		x1 = rnd() % n;
		y1 = rnd() % n;
		x2 = rnd() % n;
		y2 = rnd() % n;
		if (x1 == y1 && x2 == y2) continue;
		swap(a[x1][y1], a[x2][y2]);
	}
	cout << "-1\n";
	return 0;
}