#include <bits/stdc++.h>

using namespace std;

using ll = long long;
constexpr int MOD = 998'244'353;

int norm(ll v, const int mod) {
    if (v >= 2 * mod || v < -mod) {
        v %= mod;
    }
    if (v < 0) {
        v += mod;
    }
    if (v >= mod) {
        v -= mod;
    }
    return v;
}

template<int mod>
struct mint {
    int v;

    mint(ll x) : v(norm(x, mod)) {}

    mint &operator*=(const mint &o) {
        v = static_cast<ll>(v) * o.v % mod;
        return *this;
    }

    friend mint operator*(const mint &a, const mint &b) {
        return mint(a) *= b;
    }

    mint &operator+=(const mint &o) {
        v += o.v;
        if (v >= mod) {
            v -= mod;
        }
        return *this;
    }

    friend mint operator+(const mint &a, const mint &b) {
        return mint(a) += b;
    }

    mint &operator-=(const mint &o) {
        v -= o.v;
        if (v < 0) {
            v += mod;
        }
        return *this;
    }

    friend mint operator-(const mint &a, const mint &b) {
        return mint(a) -= b;
    }

    mint pow(long long k) const {
        mint a = *this;
        mint res = 1;
        for (; k; k >>= 1) {
            if (k & 1) {
                res *= a;
            }
            a *= a;
        }
        return res;
    }

    mint inv() const {
        return (*this).pow(mod - 2);
    }

    mint &operator/=(const mint &o) {
        *this *= o.inv();
        return *this;
    }

    friend mint operator/(const mint &a, const mint &b) {
        return mint(a) /= b;
    }
};

mint<MOD> sum_pr2(ll x) {
    if (x <= 0) {
        return 0;
    }
    mint<MOD> x2 = mint<MOD>(x);
    return x2 * (x2 + 1) * (2 * x2 + 1) / 6;
}

mint<MOD> sum_pr2(ll x, ll y) {
    return sum_pr2(y) - sum_pr2(x - 1);
}

mint<MOD> sum_pr1(ll x) {
    if (x <= 0) {
        return 0;
    }
    mint<MOD> x2 = x;
    return x2 * (x2 + 1) / 2;
}

mint<MOD> sum_pr1(ll x, ll y) {
    return sum_pr1(y) - sum_pr1(x - 1);
}

void solve() {
    long long n;
    cin >> n;
    mint<MOD> add = mint<MOD>(n) * mint<MOD>(n) * mint<MOD>(n + 1) / 2;
    constexpr int cut = 1e6;
    mint<MOD> ans = 0;
    for (int j = 1; j <= n / (cut + 1) ; ++j) {
        ans += mint<MOD>(n / j) * j * j - mint<MOD>(2 * n + 2) * (n / j) * j +
               mint<MOD>(n / j) * (n / j) * j * j;
    }
    for (int k = 1; k <= cut; ++k) {
        ll j_min = (n / (k + 1)) + 1;
        ll j_max = n / k;
        ans += k * sum_pr2(j_min, j_max);
        ans -= mint<MOD>(2 * n + 2) * k * sum_pr1(j_min, j_max);
        ans += mint<MOD>(k) * k * sum_pr2(j_min, j_max);
    }
    ans /= 2;
    cout << (ans + add).v << '\n';
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int t = 1;
//   cin >> t;
    while (t--) solve();
}