#include <bits/stdc++.h>

using namespace std;

using ll = long double;
constexpr int MOD = 998'244'353;

using ld = double;

constexpr ld eps = 1e-9;

constexpr ld PI = M_PI;

void norm(vector<ld>& ps) {
    for (ld& i : ps) {
        while (i > eps + 2 * PI) {
            i -= 2 * PI;
        }
        while (i < -2 * PI - eps) {
            i += 2 * PI;
        }
    }
}

bool check(vector<ld> pts, vector<pair<ld, ld>> sgs) {
    norm(pts);
    int x = pts.size();
    vector<int> p(x);
    iota(p.begin(), p.end(), 0);
    do {
        bool ok = true;
        for (int i = 0; i < x; ++i) {
            ok &= (pts[p[i]] - sgs[i].second) < eps;
            ok &= ( pts[p[i]] - sgs[i].first) > eps;
        }
        if (ok) {
            return true;
        }
    } while (next_permutation(p.begin(), p.end()));
    return false;
}

ld surf(ld r, vector<ld> pts) {
    norm(pts);
    sort(pts.begin(), pts.end());
    ld res = 0;
    for (int i = 0; i < pts.size(); ++i) {
        res += sin(pts[(i + 1) % pts.size()] - pts[i]);
    }
    return llabs(r * r * llabs(res) / 2);
}

void solve() {
    ld r;
    cin >> r;
    vector<ld> a(6);
    vector<pair<ld, ld>> ps(3);
    for (int i = 0; i <6; ++i) {
        cin >> a[i];
    }

    for (int i = 0; i < 3; ++i) {
        ps[i] = {a[2 * i], a[2 * i + 1]};
    }

    for (int i = 0; i < 6; ++i) {
        vector<ld> to = {a[i], a[i] + 2 * PI / 3, a[i] + 4 * PI / 3};
        vector<ld> to2 = {a[i], a[i] - 2 * PI / 3, a[i] - 4 * PI / 3};
        if (check(to, ps) || check(to2, ps)) {
            std::cout << fixed << 3 * sqrtl(3) / 4 * r * r << '\n';
            return;
        }
    }

    ld res = 0;

    for (int i = 0; i < 6; ++i) {
        for (int j = i + 1; j < 6; ++j) {
            for (int k = j + 1; k < 6; ++k) {
                if (check({a[i], a[j], a[k]}, ps)) {
                    res = max(res, surf(r, vector<ld>({a[i], a[j], a[k]})));
                }
            }
        }
    }

    for (int i = 0; i < 6; ++i) {
        for (int j = i + 1; j < 6; ++j) {
            vector<ld> ls1 = {a[i], a[j], PI + (a[i] + a[j]) / 2};
            vector<ld> ls2 = {a[i], a[j], (a[i] + a[j]) / 2};
            if (check(ls1, ps)) {
                res = max(res, surf(r, ls1));
            }
            if (check(ls2, ps)) {
                res = max(res, surf(r, ls2));
            }
        }
    }
    std::cout << fixed << res << '\n';
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.precision(16);
    int t = 1;
//   cin >> t;
    while (t--) solve();
}