#include <bits/stdc++.h>

using namespace std;

typedef long long ll;

const ll INF = 1000'000'000'000'000'000;

struct Hill {

    int l, m, r;

    Hill() {}

    Hill(int _l, int _m, int _r) {
        l = _l;
        m = _m;
        r = _r;
    }

    int num() {
        return 2 * (m - max(l, r)) + 1;
    }

    int len() {
        return 2 * m - l - r + 1;
    }

    int mx() {
        return max(max(l, r), m);
    }

    void out(){
        cout << l << " " << m << " " << r << endl;
    }

};

struct Vertex {
    Hill left, right;
    int mx;
    int ttl;

    Vertex() {}

    Vertex(Hill _left, Hill _right, int _mx, int _ttl) {
        left = _left;
        right = _right;
        mx = _mx;
        ttl = _ttl;
    }
};

Hill mrg_left(Hill& l, Hill& r) {
    vector<int> lst = {l.m, l.r, r.l, r.m, r.r};
    vector<int> done = {l.l};
    bool dwn = false;
    for (int i = 0; i < 5; i++) {
        if (i == 2 && abs(lst[i] - done.back()) != 1) {
            break;
        }
        if (lst[i] < done.back()) {
            dwn = true;
            done.push_back(lst[i]);
            continue;
        }
        if (lst[i] == done.back()) {
            done.push_back(lst[i]);
            continue;
        }
        if (dwn) {
            break;
        }
        done.push_back(lst[i]);
    }
    int cmx = 0;
    for (auto it: done) {
        cmx = max(cmx, it);
    }
    return {done[0], cmx, done.back()};
}


Hill mrg_right(Hill& l, Hill& r) {
    swap(l, r);
    swap(l.l, l.r);
    swap(r.l, r.r);
    vector<int> lst = {l.m, l.r, r.l, r.m, r.r};
    vector<int> done = {l.l};
    bool dwn = false;
    for (int i = 0; i < 5; i++) {
        if (i == 2 && abs(lst[i] - done.back()) != 1) {
            break;
        }
        if (lst[i] < done.back()) {
            dwn = true;
            done.push_back(lst[i]);
            continue;
        }
        if (lst[i] == done.back()) {
            done.push_back(lst[i]);
            continue;
        }
        if (dwn) {
            break;
        }
        done.push_back(lst[i]);
    }
    int cmx = 0;
    for (auto it: done) {
        cmx = max(cmx, it);
    }
    swap(l, r);
    swap(l.l, l.r);
    swap(r.l, r.r);
    return {done.back(), cmx, done[0]};
}
void mrg(Vertex& l, Vertex& r, Vertex & res) {
    res = {};
    res.ttl = l.ttl + r.ttl;
    res.mx = max(l.mx, r.mx);
    res.left = l.left;
    res.right = r.right;
    if (l.left.len() == l.ttl) {
        res.left = mrg_left(l.left, r.left);
    }
    if (r.right.len() == r.ttl) {
        res.right = mrg_right(l.right, r.right);
    }
    res.mx = max(res.mx, mrg_left(l.right, r.left).num());
    res.mx = max(res.mx, mrg_right(l.right, r.left).num());
}

Vertex tree[400'010];

struct Segtree {

    int n;
    vector<int> a;

    Segtree(vector<int> _a) {
        a = _a;
        n = a.size();
        build(0, 0, n);
    }

    void build(int v, int l, int r) {
        if (l + 1 == r) {
            tree[v] = {{a[l], a[l], a[l]}, {a[l], a[l], a[l]}, 1, 1};
            return;
        }
        if (l >= r) {
            return;
        }
        int m = (l + r) / 2;
        build(2 * v + 1, l, m);
        build(2 * v + 2, m, r);
        mrg(tree[2 * v + 1], tree[2 * v + 2], tree[v]);
    }

    void set(int v, int l, int r, int pos, int x) {
        if (l > pos || r <= pos) {
            return;
        }
        if (r - l == 1) {
            tree[v] = {{x, x, x}, {x, x, x}, 1, 1};
            return;
        }
        int m = (l + r) / 2;
        if (pos < m) {
            set(2 * v + 1, l, m, pos, x);
        } else {
            set(2 * v + 2, m, r, pos, x);
        }
        mrg(tree[2 * v + 1], tree[2 * v + 2], tree[v]);
    }

    int gt(){
        return tree[0].mx;
    }

};

signed main() {

    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    int n;
    cin >> n;

    vector<int> a(n, 0);

    for (int i = 0; i < n; i++) {
        cin >> a[i];
    }

    Segtree tr(a);

    cout << tr.gt() << endl;

    int q;
    cin >> q;

    while (q--) {
        int i, x;
        cin >> i >> x;
        i--;
        tr.set(0, 0, n, i, x);
        cout << tr.gt() << "\n";
    }

}