//
// Created by spb on 16.11.2025.
//
#include <bits/stdc++.h>

using namespace std;
typedef long long ll;
typedef long double ld;
#define int long long

template<typename T>
istream &operator>>(istream &in, vector<T> &a) {
    for (auto &i: a)in >> i;
    return in;
}

struct gal {
    ll inc, dec;

    ll get() {
        return min(inc, dec) * 2 + 1;
    }
};

gal rightsum(gal a, gal b, ll l, ll r) {
    if (r == l + 1 && a.dec == 0)b.inc += a.inc + 1;
    return b;
}

gal leftsum(gal a, gal b, ll l, ll r) {
    if (r + 1 == l && b.inc == 0)a.dec += b.dec + 1;
    return a;
}

struct seg {
    ll len{}, ans{};
    gal pref, suf;

    seg(ll x = 0) {
        len = 1;
        ans = 1;
        pref = suf = {0, 0};
    }
};

seg merge(seg &l, seg &r, ll x, ll y) {
    seg ans;
    ans.len = l.len + r.len;
    ans.ans = max({l.ans, r.ans, leftsum(l.suf, r.pref, x, y).get(), rightsum(l.suf, r.pref, x, y).get()});
    ans.pref = l.pref;
    if (l.pref.inc == l.len - 1 && x + 1 == y) {
        ans.pref = rightsum(l.suf, r.pref, x, y);
    }
    if (l.pref.inc == l.len - 1 && x - 1 == y) {
        ans.pref = leftsum(l.suf, r.pref, x, y);
    }
    ans.suf = r.suf;
    if (r.suf.dec == r.len - 1 && x - 1 == y) {
        ans.suf = leftsum(l.suf, r.pref, x, y);
    }
    if (r.suf.dec == r.len - 1 && x + 1 == y) {
        ans.suf = rightsum(l.suf, r.pref, x, y);
    }
    return ans;
}

struct SegTree {
    vector<seg> t;
    vector<ll> a;
    ll sz;

    SegTree(vector<ll> v = {1}) {
        a = v;
        sz = a.size();
        t.resize(4 * sz);
        build(1, 0, sz);
    }

    void build(ll v, ll l, ll r) {
        if (l + 1 == r) {
            t[v] = seg(a[l]);
        } else {
            ll m = (r + l) / 2;
            build(2 * v, l, m);
            build(2 * v + 1, m, r);
            t[v] = merge(t[2 * v], t[2 * v + 1], a[m - 1], a[m]);
        }
    }

    ll get() {
        //cout<<t[1].pref.inc<<" "<<t[1].pref.dec<<"\n"<<t[1].suf.inc<<" "<<t[1].suf.dec<<"\n";
        return t[1].ans;
    }

    void update(ll ind, ll val) {
        _update(1, 0, sz, ind, val);
    }

    void _update(ll v, ll tl, ll tr, ll ind, ll val) {
        if (tl + 1 == tr) {
            a[tl] = val;
            t[v] = seg(val);
            return;
        }
        ll tm = (tl + tr) / 2;
        if (ind < tm)_update(2 * v, tl, tm, ind, val);
        else _update(2 * v + 1, tm, tr, ind, val);
        t[v] = merge(t[2 * v], t[2 * v + 1], a[tm - 1], a[tm]);
    }
};

struct solve {

    solve() {
        ll n;
        cin >> n;
        vector<ll> v(n);
        cin >> v;
        SegTree sg = v;
        ll q;
        cin >> q;
        cout << sg.get() << "\n";
        while (q--) {
            ll ind, val;
            cin >> ind >> val;
            sg.update(ind - 1, val);
            cout << sg.get() << "\n";
        }
    }
};

//const int maxn = 301;
//int pos[maxn];
//
//void solve(){
////    int n;
////    cin >> n;
////    if (n & 1) {
////        cout << "-1\n";
////        return;
////    }
////    for (int i = 0; i < n)
//}
signed main() {
    cout.precision(20);
#ifdef home
    freopen(".in", "r", stdin);
    freopen(".out", "w", stdout);
#else
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
#endif
    int t = 1;
    //cin >> t;
    while (t--) {
        solve();
    }
}