#include <bits/stdc++.h>

using namespace std;

using ll = long long;
using ld = long double;
int INF = 1e9;
ll INFll = 1e18;
#define all(x) x.begin(), x.end()

struct node1{
    int pref_d;
    int pref_u;
    int suf_d;
    int suf_u;
    int pref_pyr;
    int suf_pyr;
    int len;
    int lef;
    int rig;

    node1(int x) : lef(x), rig(x), pref_d(1), suf_u(1), len(1), pref_pyr(1), suf_pyr(1) {}

    void calc(node1& a, node1& b) {
        len = max(a.len, b.len);

        lef = a.lef;
        rig = b.rig;
        pref_d = a.pref_d;
        suf_u = b.suf_u;
        pref_pyr = a.pref_pyr;
        suf_pyr = b.pref_pyr;
        pref_u = a.pref_u;
        if (a.rig == b.lef + 1) {
            len = max(len, a.suf_pyr + b.pref_d);
            if (a.len == a.pref_d)
                pref_d = a.pref_d + b.pref_d;
            if (a.len == a.pref_pyr)
                pref_pyr = a.pref_pyr + b.pref_d;
        }
        if (a.rig + 1 == b.lef) {
            len = max(len, a.suf_u + b.pref_pyr);
            if (b.len == b.suf_u)
                suf_u = a.suf_u + b.suf_u;
            if (b.len == b.suf_pyr)
                suf_pyr = a.suf_u + b.suf_pyr;
        }
        if (a.rig == b.lef + 1 || a.rig + 1 == b.lef){
            len = max(len, a.suf_u + b.pref_d);
        }
    }
};

struct SegTree{
    vector<node1> d;
    int n;

    SegTree(int n) : n(n), d(4 * n + 1, node1(0)) {}

    void build(int l, int r, int v, vector<int>& a) {
        if (l == r - 1) {
            d[v] = node1(a[l]);
            return;
        }

        int m = (l + r) / 2, v1 = 2 * v + 1, v2 = 2 * v + 2;
        build(l, m, v1, a);
        build(m, r, v2, a);

        d[v].calc(d[v1], d[v2]);
    }

    void upd(int it, int val, int l, int r, int v) {
        if (it < l || r <= it)
            return;

        if (l == r - 1) {
            d[v] = node1(val);
            return;
        }
        int m = (l + r) / 2, v1 = 2 * v + 1, v2 = 2 * v + 2;
        upd(it, val, l, m, v1);
        upd(it, val, m, r, v2);
        d[v].calc(d[v1], d[v2]);
    }

    int query() {
        return d[0].len;
    }
};

void E() {
    int n;
    cin >> n;
    vector<int> a(n);
    for (int i = 0; i < n; ++i)
        cin >> a[i];
    SegTree tree(n);
    tree.build(0, n, 0, a);
    cout << tree.query() << '\n';
    int q; cin >> q;
    while (q--) {
        int i, x;
        cin >> i >> x;
        tree.upd(i - 1, x, 0, n, 0);
        cout << tree.query() << '\n';
    }
}

struct Node {
    int time;
    string s;
    int len;
    Node() {

    }
};

void I() {
    int n;
    cin >> n;
    vector <pair <string, int>> v(n);
    for (auto& [s, t] : v) cin >> s >> t;
    deque <pair <int, int>> que;
    for (int i = 0; i < n; ++i) que.emplace_back(i, 0);
    int m;
    cin >> m;
    vector <Node> q(m, Node());
    for (auto& [t, s, len] : q) cin >> t >> s >> len;

    int j = 0;
    vector <pair <string, int>> ans;
    ll timer = 0;
    while (j < m) {
        while (j < m && q[j].time <= timer) que.push_front({j++, 1});
        if (que.size()) {
            int i = que.front().first;
            if (que.front().second == 0) {
                ans.emplace_back(v[i].first, timer);
                timer += v[i].second;
            }
            else {
                timer = max(timer, (ll)q[i].time);
                ans.emplace_back(q[i].s, timer);
                timer += q[i].len;
            }
            que.pop_front();
        }
        else timer = q[j].time;
    }
    for (auto& [s, t] : ans) cout << s << ' ' << t << '\n';
}

void C() {
    int n;
    cin >> n;
    vector<ll> a(n);
    for (auto& x : a)
        cin >> x;

    auto lcm = [&](ll a, ll b)->ll {
        return a / gcd(a, b) * b;
    };


}

int main() {
    ios_base::sync_with_stdio(false); cin.tie(0); cout.tie(0);
    cout << fixed;
    cout.precision(10);

    int tt = 1;
    //cin >> tt;

    while (tt--) {
        I();
    }
}