#include<bits/stdc++.h>

using ll = long long;

const int mod = 1e9 + 7;

int add(int a, int b) {
    return a + b >= mod ? a + b - mod : a + b;
}
int sub(int a, int b) {
    return a >= b ? a - b : a + mod - b;
}
int mul(int a, int b) {
    return 1ll * a * b % mod;
}

int main() {
    std::cin.tie(nullptr)->sync_with_stdio(false);

    int tests;
    std::cin >> tests;
    while (tests--) {
        int n, m, l;
        std::cin >> n >> m >> l;
        std::vector<std::tuple<int, int, ll>> edg(m);
        for (auto& [u, v, w] : edg) {
            std::cin >> u >> v >> w;
            --u, --v;
        }
        int ans = 1;
        std::vector<ll> d(n);
        for (auto& i : d) std::cin >> i;
        std::vector<std::vector<std::pair<int, ll>>> adj(n);
        for (auto& [u, v, w] : edg) {
            if (d[u] == d[v]) {
                if (w == -1) ans = mul(ans, l);
            }
            else {
                if (d[u] > d[v]) std::swap(u, v);
                adj[v].emplace_back(u, w);
            }
        }
        for (int i = 0; i < n; ++i) {
            if (i == 0) continue;
            int c1 = 1, c2 = 1;
            for (auto [j, w] : adj[i]) {
                {
                    ll bnd = std::max(1ll, d[i] - d[j]);
                    if (w != -1) c1 = mul(c1, w >= bnd);
                    else c1 = mul(c1, std::max(0ll, l - bnd + 1));
                }
                {
                    ll bnd = std::max(1ll, d[i] + 1 - d[j]);
                    if (w != -1) c2 = mul(c2, w >= bnd);
                    else c2 = mul(c2, std::max(0ll, l - bnd + 1));
                }
            }
            ans = mul(ans, sub(c1, c2));
        }
        std::cout << ans << '\n';
    }
}