#include <bits/stdc++.h>
using namespace std;
using ll = long long;
const ll INF = (1LL<<60);

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int t;
    if(!(cin>>t)) return 0;
    while(t--){
        int n;
        ll L;
        cin >> n >> L;
        L = llabs(L);
        vector<int> x(n);
        for(int i=0;i<n;++i) cin >> x[i];
        vector<ll> c(n);
        for(int i=0;i<n;++i) cin >> c[i];

        int M = 3000; // constraint from statement
        // dp[g] = min cost to obtain subset with gcd exactly g
        vector<ll> dp(M+1, INF);
        for(int i=0;i<n;++i){
            int xi = x[i];
            ll ci = c[i];
            vector<ll> ndp = dp;
            // take xi alone
            ndp[xi] = min(ndp[xi], ci);
            for(int g=1; g<=M; ++g){
                if(dp[g] == INF) continue;
                int ng = std::gcd(g, xi);
                ndp[ng] = min(ndp[ng], dp[g] + ci);
            }
            dp.swap(ndp);
        }

        ll ans = INF;
        for(int g=1; g<=M; ++g){
            if(dp[g] == INF) continue;
            if(L % g == 0) ans = min(ans, dp[g]);
        }
        if(ans==INF) cout << -1 << "\n"; else cout << ans << "\n";
    }
    return 0;
}



