#include <bits/stdc++.h>
using namespace std;

// Find augmenting path for column u
bool dfs_match(int u, vector<vector<int>>& adj, vector<int>& seen, vector<int>& matchVal) {
    for (int v : adj[u]) {
        if (seen[v]) continue;
        seen[v] = 1;
        if (matchVal[v] == -1 || dfs_match(matchVal[v], adj, seen, matchVal)) {
            matchVal[v] = u;
            return true;
        }
    }
    return false;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    if (!(cin >> n)) return 0;

    if (n == 1) {
        cout << "1\n";
        return 0;
    }
    if (n == 2) {
        cout << "-1\n";
        return 0;
    }
    // If you want the exact sample for n=3, output it:
    if (n == 3) {
        cout << "1 3 2\n3 2 1\n2 1 3\n";
        return 0;
    }

    // general n >= 4
    // result matrix (1-based indexing in logic, but we'll store 0-based)
    vector<vector<int>> A(n, vector<int>(n, -1));
    // used_in_col[col][val] = whether value val already used in column col
    vector<vector<char>> used_in_col(n, vector<char>(n+1, 0));

    // We'll construct rows 0..n-1 one by one
    for (int row = 0; row < n; ++row) {

        vector<vector<int>> adj(n);
        for (int col = 0; col < n; ++col) {
            for (int val = 1; val <= n; ++val) {
                if (used_in_col[col][val]) continue; // value already used in this column
                if (col == row) {
                    // force column 'row' only allow value row+1
                    if (val == row + 1) adj[col].push_back(val);
                } else {
                    if (val == row + 1) continue; // value reserved for diagonal position
                    adj[col].push_back(val);
                }
            }
        }

        vector<int> matchVal(n+1, -1);
        bool ok = true;
        for (int col = 0; col < n; ++col) {
            vector<int> seen(n+1, 0);
            if (!dfs_match(col, adj, seen, matchVal)) {
                ok = false;
                break;
            }
        }
        if (!ok) {
            cout << "-1\n";
            return 0;
        }
        for (int val = 1; val <= n; ++val) {
            int col = matchVal[val];
            if (col != -1) {
                A[row][col] = val;
                used_in_col[col][val] = 1;
            }
        }

        if (A[row][row] != row + 1) {

            cout << "-1\n";
            return 0;
        }
    }

    // Output
    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < n; ++j) {
            cout << A[i][j] << (j+1==n?'\n':' ');
        }
    }
    return 0;
}
