#include <bits/stdc++.h>
using namespace std;

int calculate_grundy(long long x) {
    if (x == 1) return 0;

    long long temp = x;
    int distinct_primes = 0;
    bool has_square = false;
    
    for (long long p = 2; p * p <= temp; p++) {
        if (temp % p == 0) {
            distinct_primes++;
            int count = 0;
            while (temp % p == 0) {
                temp /= p;
                count++;
            }
            if (count > 1) has_square = true;
        }
    }
    
    if (temp > 1) {
        distinct_primes++;
    }
    
    if (distinct_primes == 0) return 0; // x = 1
    if (distinct_primes == 1) {
        return has_square ? 1 : 0;
    }
    return 2;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    int t;
    cin >> t;
    
    while (t--) {
        int n;
        cin >> n;
        
        int xor_val = 0;
        for (int i = 0; i < n; i++) {
            long long x;
            cin >> x;
            xor_val ^= calculate_grundy(x);
        }
        
        cout << (xor_val != 0 ? "Yes" : "No") << "\n";
    }
    
    return 0;
}