#include <bits/stdc++.h>
using namespace std;

const int MOD = 998244353;
const int MAXN = 2000005;
const int MAXA = 10000005;

int n;
int a[MAXN];
int pref_gcd[MAXN], suff_gcd[MAXN];

// Функция для быстрого вычисления НОД
int gcd(int a, int b) {
    while (b) {
        int temp = a % b;
        a = b;
        b = temp;
    }
    return a;
}

// Функция для быстрого вычисления НОК
long long lcm(int a, int b) {
    return (1LL * a * b) / gcd(a, b);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    cin >> n;
    for (int i = 1; i <= n; i++) {
        cin >> a[i];
    }
    
    // Вычисляем префиксные НОД
    pref_gcd[0] = 0;
    for (int i = 1; i <= n; i++) {
        pref_gcd[i] = gcd(pref_gcd[i-1], a[i]);
    }
    
    // Вычисляем суффиксные НОД
    suff_gcd[n+1] = 0;
    for (int i = n; i >= 1; i--) {
        suff_gcd[i] = gcd(suff_gcd[i+1], a[i]);
    }
    
    long long answer = 0;
    
    // Перебираем все возможные отрезки [i,j]
    for (int i = 1; i <= n; i++) {
        long long current_lcm = a[i];
        for (int j = i; j <= n; j++) {
            // Обновляем НОК для текущего отрезка
            current_lcm = lcm(current_lcm, a[j]);
            if (current_lcm > 1e15) break; // Предотвращаем переполнение
            
            // Вычисляем f(i,j)
            int left_gcd = pref_gcd[i-1];
            int right_gcd = suff_gcd[j+1];
            int total_gcd = gcd(gcd(left_gcd, right_gcd), (int)(current_lcm % MOD));
            
            answer = (answer + total_gcd) % MOD;
        }
    }
    
    cout << answer << endl;
    
    return 0;
}