#include <bits/stdc++.h>

using namespace std;
using ll = long long;
using ld = long double;
const ll INF = 1e18;
const ll inf = 1e9;
const ll MOD = 1e9 + 7;
struct node1 {
    string name;
    int len;
};
struct node2 {
    string name;
    int len;
    int start;
    int in;
};

bool cmp(node2 a, node2 b) {
    if (a.start == b.start) {
        return a.in < b.in;
    }
    return a.start < b.start;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    int n;
    cin >> n;
    deque<node1> all_songs;
    for (int i = 0; i < n; ++i) {
        string name;
        int len;
        cin >> name >> len;
        all_songs.push_back({name, len});
    }
    int m;
    cin >> m;
    vector<node2> next(m);
    for (int i = 0; i < m; ++i) {
        int t, len;
        string name;
        cin >> t >> name >> len;
        next[i] = {name, len, t, i};
    }
    int cur_time = 0;
    int in_next = 0;
    while (!all_songs.empty() || in_next != m) {
        if (all_songs.empty()) {
            all_songs.push_front({next[in_next].name, next[in_next].len});
            cur_time = next[in_next].start;
            in_next++;
        }
        while (in_next < m && next[in_next].start <= cur_time) {
            all_songs.push_front({next[in_next].name, next[in_next].len});
            in_next++;
        }
        cout << all_songs.front().name << " " << cur_time << '\n';
        cur_time += all_songs.front().len;
        all_songs.pop_front();
    }
}