
#include <bits/stdc++.h>
using namespace std;

double area(double A, double B, double C) {
    double v = sin(B-A) + sin(C-B) + sin(A-C);
    return fabs(v);
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    double r;
    cin >> r;

    double a1,a2,b1,b2,c1,c2;
    cin >> a1 >> a2 >> b1 >> b2 >> c1 >> c2;

    double best = 0;

    const int STARTS = 400; 
    
    mt19937_64 rng(123456);

    auto rnd = [&](double L, double R) {
        return L + (R-L)*(double(rng())/rng.max());
    };

    for(int s=0; s<STARTS; s++){
        double A = rnd(a1,a2);
        double B = rnd(b1,b2);
        double C = rnd(c1,c2);

        double step = 0.05;  

        for(int it=0; it<200; it++){
            bool iii = false;

           for(double dA: { -step, step }) {
                double A2 = A + dA;
                if(A2 < a1 || A2 > a2) continue;
                if(area(A2,B,C) > area(A,B,C)){
                    A = A2; iii = true;
                }
            }

            for(double dB: { -step, step }) {
                double B2 = B + dB;
                if(B2 < b1 || B2 > b2) continue;
                if(area(A,B2,C) > area(A,B,C)){
                    B = B2; iii = true;
                }
            }

            for(double dC: { -step, step }) {
                double C2 = C + dC;
                if(C2 < c1 || C2 > c2) continue;
                if(area(A,B,C2) > area(A,B,C)){
                    C = C2; iii = true;
                }
            }

            if(!iii) step *= 0.45; 

            if(step < 1e-9) break;
        }

        best = max(best, area(A,B,C));
    }

    double result = best * r * r * 0.5;
    cout << fixed << setprecision(12) << result << "\n";
}