#include "bits/stdc++.h"

using namespace std;
#define int long long

struct pal {
    int pl = 0, mn = 0;
};
struct node {
    int maxlen = 0, suf1 = 0, prefm1 = 0;
    pal suf, pref;
};
node merge (node a, node b, int len) {
    node ans;
    ans.maxlen = max(a.maxlen, b.maxlen);
    {
        int val1 = a.suf.pl;
        if (a.suf.mn == 0) {
            val1 += b.pref.pl;
            int val2 = b.pref.mn;
            ans.maxlen = max(ans.maxlen, min(val1, val2));
        } else {
            int val2 = a.suf.mn + b.prefm1;
            ans.maxlen = max(ans.maxlen, min(val1, val2));
        }

    }
    ans.suf1 = b.suf1;
    if (b.suf1 == len) {
        ans.suf1 += a.suf1;
    }
    ans.prefm1 = a.prefm1;
    if (a.prefm1 == len) {
        ans.prefm1 += b.prefm1;
    }

    {
        ans.pref = a.pref;
        if (a.pref.pl + a.pref.mn == len) {
            if (a.pref.pl == len) {
                ans.pref.pl += b.pref.pl;
                ans.pref.mn += b.pref.mn;
            } else {
                ans.pref.mn += b.prefm1;
            }
        }
    }
    {
        ans.suf = b.suf;
        if (b.suf.pl + b.suf.mn == len) {
            if (a.suf.mn == len) {
                ans.suf.mn += a.suf.mn;
                ans.suf.pl += a.suf.pl;
            } else {
                ans.suf.pl += b.suf1;
            }
        }
    }
    return ans;
}

struct segtree {
    vector<node> tree;
    int size;
    void init(vector<int> &a, int n) {
        size = 1;
        while (size < n)size *= 2;
        tree.assign(2 * size - 1, {0, 0, 0, {0, 0}, {0, 0}});
        build(a, 0, 0, size);
    }
    void build(vector<int> &a, int x, int lx, int rx) {
        if (rx - lx == 1) {
            if (lx >= (int)a.size())return;
            if (a[lx] == -1) {
                tree[x] = {0, 0, 1, {0, 1}, {0, 1}};
            } else if (a[lx] == 1) {
                tree[x] = {0, 1, 0, {1, 0}, {1, 0}};
            }
            return;
        }
        int mid = (lx + rx) / 2;
        build(a, 2 * x + 1, lx, mid);
        build(a, 2 * x + 2, mid, rx);
        tree[x] = merge(tree[2 * x + 1], tree[2 * x + 2], (rx - lx) / 2);
    }
    void set(int ind, int val) {
        set(ind, val, 0, 0, size);
    }
    void set(int ind, int val, int x, int lx, int rx) {
        if (rx - lx == 1) {
            if (val == -1) {
                tree[x] = {0, 0, 1, {0, 1}, {0, 1}};
            } else if (val == 1) {
                tree[x] = {0, 1, 0, {1, 0}, {1, 0}};
            } else {
                tree[x] = {0, 0, 0, {0, 0}, {0, 0}};
            }
            return;
        }
        int mid = (lx + rx) / 2;
        if (ind < mid) {
            set(ind, val, 2 * x + 1, lx, mid);
        } else {
            set(ind, val, 2 * x + 2, mid, rx);
        }
        tree[x] = merge(tree[2 * x + 1], tree[2 * x + 2], (rx - lx) / 2);
    }

};

void solve(int test) {
    int n; cin >> n;
    vector<int> b(n);
    for (int &i :b)cin >> i;
    n--;
    vector<int> a(n);
    for (int i = 0; i < n; ++i) {
        a[i] = b[i + 1] - b[i];
    }
    segtree sg;
    sg.init(a, n);
    cout << sg.tree[0].maxlen * 2 + 1 << '\n';
    int q; cin >> q;
    while (q--) {
        int ind, val; cin >> ind >> val;
        ind--;
        b[ind] = val;

        if (ind > 0) {
            sg.set(ind - 1, b[ind] - b[ind - 1]);
            a[ind - 1] = b[ind] - b[ind - 1];
        }
        if (ind < n) {
            sg.set(ind, b[ind + 1] - b[ind]);
            a[ind] = b[ind + 1] - b[ind];
        };
        cout << sg.tree[0].maxlen * 2 + 1 << '\n';
    }
}

signed main() {
#ifdef local
    freopen("input.txt", "r", stdin);
    freopen("output.txt", "w", stdout);
#endif
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int akbalin = 1;
    //cin >> akbalin;

    for (int i = 1; i <= akbalin; i++) {
        solve(i);
    }
}
