import sys

def solve():
    # Установка быстрого чтения
    input = sys.stdin.read
    data = input().split()
    
    T = int(data[0])
    results = []
    
    ptr = 1
    for _ in range(T):
        N = int(data[ptr])
        ptr += 1
        
        A = []
        for i in range(N):
            A.append(int(data[ptr + i]))
        ptr += N
        
        D = 30
        
        # 1. Создание частотного словаря F[y] = count(y) mod 2
        # F - это разреженный вектор f
        F = {}
        has_nonzero_F = False
        for a in A:
            F[a] = F.get(a, 0) ^ 1
            if F[a] == 1:
                has_nonzero_F = True
            elif F[a] == 0:
                # Если F[a] стало 0, удаляем ключ для экономии
                F.pop(a)

        # 2. Проверка существования решения (Теорема: существует <=> F не нулевой)
        if not has_nonzero_F:
            results.append("-1")
            continue

        # 3. Вычисление Chi[x] (обратное преобразование Мебиуса)
        # Инициализируем Chi = F
        Chi = F.copy()
        
        # Получаем все уникальные ключи для итерации
        all_masks = set(Chi.keys())
        
        # Выполняем Fast Zeta Transform (FWHT)
        for j in range(D):
            new_keys = set()
            
            # Итерируем по всем существующим маскам
            for mask in all_masks:
                # Если j-й бит в mask установлен (mask | (1 << j) == mask)
                if (mask >> j) & 1:
                    mask_without_j = mask ^ (1 << j)
                    
                    # Chi[mask] += Chi[mask_without_j] mod 2
                    
                    # Проверяем, существует ли mask_without_j
                    if mask_without_j in Chi:
                        Chi[mask] ^= Chi[mask_without_j]
                        
                        if Chi[mask] == 0:
                            # Удаление Chi[mask] не нужно, так как mask уже
                            # был в all_masks, и мы его не добавляем
                            pass 
                    
                    # Если mask_without_j не существует в Chi (т.е., F[mask_without_j] = 0)
                    # то ничего не меняется, Chi[mask] ^= 0

                    
            # Обновление ключей для следующей итерации не нужно,
            # так как мы используем Chi.keys() только в начале цикла.
            # Но для корректности FWHT для разреженных данных,
            # мы должны итерироваться по всем маскам, которые могут быть источником.
            # Упрощенная итерация по ключам Chi, которая работает:
            keys_to_update = list(Chi.keys())
            for mask in keys_to_update:
                if (mask >> j) & 1:
                    mask_without_j = mask ^ (1 << j)
                    
                    # Только если маска без j-го бита существует
                    if mask_without_j in Chi:
                        Chi[mask] ^= Chi[mask_without_j]

        # 4. Найти минимальное x, для которого Chi[x] = 1
        min_x = -1
        
        # Сначала ищем среди существующих ключей (которые были в F)
        for x in sorted(Chi.keys()):
            if Chi[x] == 1:
                min_x = x
                break

        # Поскольку мы не генерируем все 2^30 масок, Chi[x] может отсутствовать.
        # Но по теореме, если Chi[x] = 1, то x будет находиться в Chi.
        
        # Проверка всех масок в Chi на наличие 1 не требуется,
        # так как мы ищем ЛЮБОЕ x. Первый найденный x в Chi.keys() - решение.
        
        results.append(str(min_x))

    sys.stdout.write("\n".join(results) + "\n")

if __name__ == "__main__":
    solve()
