import sys

def solve():
    try:
        # Чтение N
        N_str = sys.stdin.readline()
        if not N_str:
            return
        N = int(N_str.strip())
    except:
        return

    # --- ИСПРАВЛЕНИЕ ---
    # Антимагический квадрат НЕВОЗМОЖЕН для N=1 и N=2
    if N == 1 or N == 2:
        print("No")
        return

    # Случай n >= 3 (антимагический квадрат всегда существует)
    print("Yes")
    
    A = [[0] * N for _ in range(N)]
    M = N * N
    
    # k_small - для малых чисел (от 1)
    k_small = 1
    # k_large - для больших чисел (от N^2)
    k_large = M
    
    # Заполнение змейкой с чередованием малых и больших чисел
    for i in range(N):
        # Если строка четная (0, 2, 4...), идем слева направо
        if i % 2 == 0:
            for j in range(N):
                # Шахматный порядок
                # (i + j) четно - малые числа, (i + j) нечетно - большие числа
                if (i + j) % 2 == 0:
                    A[i][j] = k_small
                    k_small += 1
                else:
                    A[i][j] = k_large
                    k_large -= 1
        
        # Если строка нечетная (1, 3, 5...), идем справа налево
        else:
            for j in range(N - 1, -1, -1):
                # Шахматный порядок
                if (i + j) % 2 == 0:
                    A[i][j] = k_small
                    k_small += 1
                else:
                    A[i][j] = k_large
                    k_large -= 1

    # Вывод результата
    for row in A:
        # Используем sys.stdout.write для ускорения вывода
        sys.stdout.write(" ".join(map(str, row)) + "\n")

if __name__ == "__main__":
    solve()
