import sys
import math

# Установка лимита рекурсии для безопасности, хотя не используется
# sys.setrecursionlimit(3000)

MOD = 998244353
MAX_A = 10**7

# --- Математические функции ---

def gcd(a, b):
    # Встроенный math.gcd
    return math.gcd(a, b)

def lcm(a, b):
    if a == 0 or b == 0:
        return 0
    # Проверка на переполнение не нужна, так как LCM используется только
    # для определения границ, а не для вычисления финальной суммы.
    # Фактическое значение L_cur > 10^7 будет означать, что оно не является
    # делителем G_prime, что нас интересует.
    if a > MAX_A and b > MAX_A:
        return MAX_A + 1 # Считаем, что оно "огромное"
    
    # Применяем стандартную формулу LCM
    res = (a // gcd(a, b)) * b
    return min(res, MAX_A + 1) # Обрезаем, если больше MAX_A

# --- Решатель ---

def solve():
    try:
        # Ускорение чтения
        input = sys.stdin.read
        data = input().split()
        
        if not data: return
        
        N = int(data[0])
        A = [0] + [int(x) for x in data[1:N+1]] # 1-индексация
    except Exception:
        return

    # 1. Предобработка (Префиксный и Суффиксный GCD)
    P = [0] * (N + 2) # P[i] = gcd(a_1, ..., a_i)
    S = [0] * (N + 2) # S[i] = gcd(a_i, ..., a_n)
    
    # P[0] = 0 (gcd пустого множества, далее gcd(0, x) = x)
    for i in range(1, N + 1):
        P[i] = gcd(P[i-1], A[i]) if P[i-1] != 0 else A[i]
        
    # S[N+1] = 0
    for i in range(N, 0, -1):
        S[i] = gcd(S[i+1], A[i]) if S[i+1] != 0 else A[i]

    # Инициализация для случая gcd(x, 0) = x
    P[0] = 0
    S[N+1] = 0

    total_sum = 0
    
    # 2. Главный цикл по i
    for i in range(1, N + 1):
        
        # G_prefix = gcd(a_1...a_{i-1})
        G_prefix = P[i-1]
        
        j = i
        L_cur = 1 # lcm(a_i)
        
        # 3. Внешний цикл: Группировка по LCM (L_cur)
        while j <= N:
            j_start = j
            L_prev = L_cur
            
            # Находим следующее значение LCM
            L_cur = lcm(L_prev, A[j])
            
            # Находим конец блока j_end, где LCM остается L_cur
            j_end = j
            if L_cur <= MAX_A:
                # Нам нужен самый большой j_end такой, что lcm(L_cur, A[k]) = L_cur для k <= j_end
                # L_cur уже включает A[j_start]. Ищем, пока lcm не изменится.
                # Это можно найти бинарным поиском, но линейный поиск работает достаточно быстро
                # из-за ограниченного числа изменений LCM.
                temp_j = j + 1
                while temp_j <= N and lcm(L_cur, A[temp_j]) == L_cur:
                    temp_j += 1
                j_end = temp_j - 1
            else:
                # Если LCM уже огромное, оно останется таким до конца.
                j_end = N
            
            # Фиксированный GCD внешнего множества с LCM
            G_prime = gcd(G_prefix, L_cur)
            
            # 4. Внутренний цикл: Группировка по Суффиксному GCD (S_{k+1})
            k = j_start
            while k <= j_end:
                k_start = k
                
                # S_cur = gcd(a_{k+1}, ..., a_n)
                S_cur = S[k+1]
                
                # Находим конец подблока k_end, где S_{k+1} остается константным
                k_end = j_end
                
                # Находим следующий индекс m > k+1, где S[m] != S_cur.
                # Поскольку S[k] меняется не более O(log A) раз, 
                # мы можем найти следующий индекс, где S[k+1] != S_cur
                # путем линейного поиска или заранее вычисленных границ.
                # Из-за свойств GCD, S[m] != S_cur только если m меняет значение.
                # Самый простой способ - найти, когда S[m] < S_cur
                
                temp_k = k + 1
                while temp_k <= j_end and S[temp_k + 1] == S_cur:
                    temp_k += 1
                k_end = temp_k - 1

                
                # Количество элементов в этом подблоке
                count = k_end - k_start + 1
                
                # Боевая сила в этом подблоке
                f_val = gcd(G_prime, S_cur)
                
                # Добавление к сумме
                total_sum = (total_sum + count * f_val) % MOD
                
                k = k_end + 1
            
            j = j_end + 1
            
    # Вывод
    print(total_sum)

if __name__ == "__main__":
    # Установка рекурсивных функций для встроенных math
    # Для gcd
    if not hasattr(math, 'gcd'):
        def _gcd(a, b):
            while b:
                a, b = b, a % b
            return a
        math.gcd = _gcd

    solve()
