import sys
input = sys.stdin.readline

def sos_xor(f, n):
    # SOS XOR по подмаскам
    for i in range(n):
        for mask in range(1 << n):
            if (mask & (1 << i)) != 0:
                f[mask] ^= f[mask ^ (1 << i)]

t = int(input())
for _ in range(t):
    n = int(input())
    arr = list(map(int, input().split()))
    
    # Собираем все уникальные числа и считаем частоту по модулю 2
    freq = {}
    for x in arr:
        freq[x] = freq.get(x, 0) ^ 1  # XOR по модулю 2
    
    # Если нет ни одного 1 — сразу -1
    if all(v == 0 for v in freq.values()):
        print(-1)
        continue
    
    # Собираем все уникальные числа с freq=1
    keys = [k for k,v in freq.items() if v == 1]
    
    # Определяем все биты, которые встречаются среди keys
    used_bits = set()
    for x in keys:
        for b in range(30):
            if (x >> b) & 1:
                used_bits.add(b)
    used_bits = sorted(used_bits)
    k = len(used_bits)
    
    # Создаём отображение из оригинального числа в сжатую маску
    def compress(x):
        res = 0
        for i,b in enumerate(used_bits):
            if (x >> b) & 1:
                res |= (1 << i)
        return res
    
    size = 1 << k
    f = [0] * size
    
    # Заполняем f: для каждого числа freq=1 ставим 1
    for x in keys:
        f[compress(x)] ^= 1
    
    # Выполняем SOS XOR
    for i in range(k):
        for mask in range(size):
            if (mask & (1 << i)) != 0:
                f[mask] ^= f[mask ^ (1 << i)]
    
    # Найдем любое x с f[x] == 1
    answer = -1
    for mask in range(size):
        if f[mask] == 1:
            # раскодируем mask обратно в 30-битное число
            x = 0
            for i,b in enumerate(used_bits):
                if (mask >> i) & 1:
                    x |= (1 << b)
            answer = x
            break
    
    print(answer)