import sys
input = sys.stdin.readline

def miller_rabin(n):
    if n < 2:
        return False
    # Проверяем на тривиальные делители
    for p in [2, 3, 5, 7, 11, 13, 17, 19, 23]:
        if n == p:
            return True
        if n % p == 0 and n != p:
            return False

    # Представим n-1 как d*2^r
    d = n - 1
    r = 0
    while d % 2 == 0:
        d >>= 1
        r += 1

    def check(a):
        x = pow(a, d, n)
        if x == 1 or x == n - 1:
            return True
        for _ in range(r - 1):
            x = (x * x) % n
            if x == n - 1:
                return True
        return False

    for a in [2, 3, 5, 7, 11]:
        if a >= n:
            break
        if not check(a):
            return False
    return True

t = int(input())
for _ in range(t):
    n = int(input())
    arr = list(map(int, input().split()))

    xor_sum = 0
    for x in arr:
        if x == 2 or miller_rabin(x):
            # Простое или 2 -> проигрышная позиция (0)
            state = 0
        else:
            # Составное -> выигрышная (1)
            state = 1
        xor_sum ^= state

    print("Yes" if xor_sum != 0 else "No")