#include <bits/stdc++.h>

using namespace std;
using ll = long long;
using ld = long double;

const int N = 3e3;

void solve() {
    int n, L;
    cin >> n >> L;
    L = abs(L);

    vector<pair<ll, ll>> a(n);
    for (int i = 0; i < n; ++i) cin >> a[i].first;
    for (int i = 0; i < n; ++i) cin >> a[i].second;

    vector<ll> dp(N + 1, 1e18);
    for (int i = 0; i < n; ++i) {
        auto [x, c] = a[i];
        dp[x] = min(dp[x], c);
    }

    for (auto &[x, c]: a) {
        for (int j = 1; j <= N; ++j) {
            dp[gcd(j, x)] = min(dp[gcd(j, x)],
                                dp[j] + c);
        }
    }

    ll ans = 1e18;
    for (int i = 1; i <= N; ++i) {
        if (L % i == 0 && dp[i] != (ll) 1e18) {
            ans = min(ans, dp[i]);
        }
    }
    if (ans == (ll) 1e18) cout << "-1\n";
    else cout << ans << "\n";
}

signed main() {
#ifdef LOCAL
    freopen("input.txt", "r", stdin);
    freopen("output.txt", "w", stdout);
#endif
    ios::sync_with_stdio(false);
    cout.tie(nullptr), cin.tie(nullptr);
    int t = 1;
    cin >> t;
    while (t--) solve();
}