#include <iostream>
#include <cmath>
#include <iomanip>

using namespace std;

double triangle_area(double r, double a1, double a2, double b1, double b2, double c1, double c2) {

    double max_area = 0.0;
    
    double boundaries[] = {a1, a2, b1, b2, c1, c2};
    
    for (double a : {a1, a2}) {
        for (double b : {b1, b2}) {
            for (double c : {c1, c2}) {
                double ab = 2 * r * sin(fabs(a - b) / 2);
                double bc = 2 * r * sin(fabs(b - c) / 2);
                double ca = 2 * r * sin(fabs(c - a) / 2);
                
                double s = (ab + bc + ca) / 2;
                double area = sqrt(s * (s - ab) * (s - bc) * (s - ca));
                
                if (area > max_area) {
                    max_area = area;
                }
            }
        }
    }
    
    return max_area;
}

int main() {
    double r;
    cin >> r;
    
    double a1, a2, b1, b2, c1, c2;
    cin >> a1 >> a2 >> b1 >> b2 >> c1 >> c2;
    
    double result = triangle_area(r, a1, a2, b1, b2, c1, c2);
    cout << fixed << setprecision(10) << result << endl;
    
    return 0;
}