#include <iostream>
#include <cmath>
#include <iomanip>
#include <vector>
#include <algorithm>

using namespace std;

double triangle_area(double r, double a1, double a2, double b1, double b2, double c1, double c2) {
    auto chord_length = [r](double angle1, double angle2) {
        return 2.0 * r * sin(fabs(angle1 - angle2) / 2.0);
    };
    
    auto area_from_angles = [&](double a, double b, double c) {
        double ab = chord_length(a, b);
        double bc = chord_length(b, c);
        double ca = chord_length(c, a);
        double s = (ab + bc + ca) / 2.0;
        return sqrt(s * (s - ab) * (s - bc) * (s - ca));
    };
    
    double max_area = 0.0;
    const int num_samples = 50; 
    
    vector<double> arc_a, arc_b, arc_c;
    
    for (int i = 0; i < num_samples; i++) {
        arc_a.push_back(a1 + (a2 - a1) * i / (num_samples - 1));
        arc_b.push_back(b1 + (b2 - b1) * i / (num_samples - 1));
        arc_c.push_back(c1 + (c2 - c1) * i / (num_samples - 1));
    }
    
    for (double angle_a : arc_a) {
        for (double angle_b : arc_b) {
            double ab_chord = chord_length(angle_a, angle_b);
            
            for (double angle_c : arc_c) {
                double bc_chord = chord_length(angle_b, angle_c);
                double ca_chord = chord_length(angle_c, angle_a);
                
                double s = (ab_chord + bc_chord + ca_chord) / 2.0;
                double area = sqrt(s * (s - ab_chord) * (s - bc_chord) * (s - ca_chord));
                
                if (area > max_area) {
                    max_area = area;
                }
            }
        }
    }
    
    return max_area;
}

int main() {
    double r;
    cin >> r;
    
    double a1, a2, b1, b2, c1, c2;
    cin >> a1 >> a2 >> b1 >> b2 >> c1 >> c2;
    
    double result = triangle_area(r, a1, a2, b1, b2, c1, c2);
    cout << fixed << setprecision(10) << result << endl;
    
    return 0;
}