#include <iostream>
#include <vector>
#include <algorithm>
#include <cassert>
#include <string>
#include <deque>
#include <set>
#include <map>

using namespace std;
using ll = long long;
using ull = unsigned long long;
using ld = long double;

const int INF = 1e9 + 7;
const ll LL_INF = 4e18;

ostream& operator << (ostream& out, const vector<ll>& a) {
	for (const ll el : a) out << el << ' ';
	return out;
}
ostream& operator << (ostream& out, const vector<vector<ll>>& a) {
	for (const vector<ll>& x : a) out << x << '\n';
	return out;
}
ostream& operator << (ostream& out, const vector<pair<ll,ll>>& a) {
	for (const pair<ll,ll>& x : a) out << x.first << ' ' << x.second << '|';
	return out;
}
ostream& operator << (ostream& out, const vector<vector<pair<ll,ll>>>& a) {
	for (const vector<pair<ll,ll>>& x : a) out << x << '\n';
	return out;
}

ostream& operator << (ostream& out, const vector<int>& a) {
	for (const int el : a) out << el << ' ';
	return out;
}
ostream& operator << (ostream& out, const vector<vector<int>>& a) {
	for (const vector<int>& x : a) out << x << '\n';
	return out;
}
ostream& operator << (ostream& out, const vector<pair<int, int>>& a) {
	for (const pair<int, int>& x : a) out << x.first << ' ' << x.second << '|';
	return out;
}
ostream& operator << (ostream& out, const vector<vector<pair<int, int>>>& a) {
	for (const vector<pair<int, int>>& x : a) out << x << '\n';
	return out;
}

ll grundy(ll a) {
	if (a == 0 || a == 1 || a == 2) return 0;
	else if (a % 4 == 3 || a % 4 == 1) return 0;
	else if (a % 4 == 0) return 1;
	else return 2;
}

void solve() {
	int n;
	cin >> n;

	ll gr = 0;
	ll c;

	for (int i = 0; i < n; ++i) {
		cin >> c;
		gr ^= grundy(c);
	}

	cout << (gr == 0 ? "No\n" : "Yes\n");
}

int main() {
	ios_base::sync_with_stdio(false); cin.tie(nullptr); cout.tie(nullptr);
	int TC=1;
	cin >> TC;
	//TC = 1;

	while (TC--) {
		solve();
	}


	return 0;
}