#include <bits/stdc++.h>

using namespace std;

#define all(x) x.begin(), x.end()

const int N = 1e7 + 19;

const int M = 1e6 + 19;

int f[N];
int dp[N];

const int Mod = 998244353;

void add(int &x, const int &y){
	x += y;
	
	if ( x >= Mod ) x -= Mod;
	if ( x < 0 ) x += Mod;
}

int Hash(int x){
	return (x * 31LL % Mod + 172349) % Mod;
}

struct g_table{
	vector <vector<pair<int,pair<int,int>>>> G;
	
	g_table() : G(M) {}

	void ins(pair <int,int> p, int y){
		auto [l, r] = p;
		
		int x = (l * 31LL + r * 51LL) % Mod;
		
		x = Hash(x) % M;
		
		G[x].push_back({y, p});
	}
	
	void add(pair <int,int> p, int y){
		auto [l, r] = p;
		
		int x = (l * 31LL + r * 51LL) % Mod;
		
		x = Hash(x) % M;
		
		for ( auto &[v, q]: G[x] ){
			if ( q == p ){
				v += y;
				
				break;
			}
		}
	}

	int get(pair <int,int> p){
		auto [l, r] = p;
		
		int x = Hash((l * 31LL + r * 51LL) % Mod) % M;
		
		for ( auto &[v, q]: G[x] ){
			if ( q == p ) return v;
		}
		
		return 0;
	}
};

signed main() {
	ios_base::sync_with_stdio(0);
	cin.tie(0);
	
	vector <int> p;
	
	for ( int i = 2; i < N; i++ ){
		if ( !f[i] ){
			f[i] = i, p.push_back(i);
		}
		
		for ( int j = 0; j < (int)p.size() && p[j] <= f[i]; j++ ){
			if ( p[j] >= N / i ) break;
			
			f[i * p[j]] = p[j];
		}
	}
	
	int n;
	cin >> n;
	vector<int> a(n + 1);
	map<pair<int, int>, vector<int>> mp;
	g_table cur;
	for(int i = 1; i <= n; i++) {
		cin >> a[i];
		int cnt = 0, lst = 0;
		int x = a[i];
		while(x > 1) {
			if(lst != f[x]) {
				lst = f[x];
				cnt = 1;
			} else cnt++;
			mp[{lst, cnt}].push_back(i);
			if ( cur.get({lst, cnt}) == 0 ){
				cur.ins({lst, cnt}, 0);
			}
			cur.add({lst, cnt}, 1);
			x /= f[x];
		}
	}
	for(int i = 1; i <= n; i++) {
		int lm = 1;
		for(int j = i; j <= n; j++) {
			lm = lcm(lm, a[j]);
			int gd = lm;
			for(int k = 1; k <= n; k++) {
				if(k >= i && k <= j) continue;
				gd = __gcd(gd, a[k]);
			}
		}
	}
	g_table pref, suff;
	for(auto [x, y] : mp) {
		int cnt = 0;
		for(int i = 0; i < (int)y.size(); i++) {
			if(y[i] != i + 1) break;
			cnt = i + 1;
		}
		int cnt1 = 0, l = n;
		for(int i = (int)y.size() - 1; i >= 0; i--) {
			if(y[i] != l) break;
			cnt1 = l;
			l--;
		}
		pref.ins(x, cnt);
		suff.ins(x, cnt1);
	}
	dp[1] = (n * 1LL * (n + 1)) / 2 % Mod;
	for(int x = 2; x < N; x++) {
		int mn = n + 1;
		int l = n + 1, r = 0;
		int lst = -1, cnt = 0;
		int y = x;
		while(y > 1) {
			if(lst != f[y]) {
				if(lst != -1) {
					int A = pref.get({lst, cnt});
					int B = suff.get({lst, cnt});
					if(A == 0) l = -1;
					if(B == 0) r = -1;
					if(l != -1) l = min(l, A);
					if(r != -1) r = max(r, B);
					mn = min(mn, cur.get({lst, cnt}));
					if(mn == 0) break;
				}
				lst = f[y];
				cnt = 1;
			} else {
				cnt++;
			}
			y = y / f[y];
		}
		if(mn == 0) continue;
		int A = pref.get({lst, cnt});
		int B = suff.get({lst, cnt});
		if(A == 0) l = -1;
		if(B == 0) r = -1;
		if(l != -1) l = min(l, A);
		if(r != -1) r = max(r, B);
		mn = min(mn, cur.get({lst, cnt}));
		if(l == n + 1) l = -1;
		if(r == 0) r = -1;
		if(l == -1) l = 0;
		if(r == -1) r = n + 1;
		if(l == n && r == 1) {
			dp[x] = (n * 1LL * (n + 1)) / 2 % Mod;
		}
		int CNT = l + (n + 1 - r);
		bool flag = 0;
		if(CNT < mn) {
			flag = 1;
		}
		if(flag) {
			dp[x] = (l + 1) * 1LL * (n + 1 - r + 1) % Mod;
		} else {
			dp[x] = ((l) * 1LL * (n + 1 - r) % Mod + l + n + 1 - r) % Mod;
		}
	}
	for(int x = N - 1; x >= 1; x--) {
		if(dp[x] == 0) continue;
		for(int y = x * 2; y < N; y += x) {
			add(dp[x], -dp[y]);
		}
	}
	int ans = 0;
	for(int x = 1; x < N; x++) {
		add(ans, (dp[x] * 1LL * x) % Mod);
	}
	cout << ans;
	
}
