#include <iostream>
#include <algorithm>
#include <cmath>
#include <string>
#include <iomanip>
#include <map>
#include <set>
#include <vector>
#include <unordered_map>
#include <unordered_set>
#include <cassert>
#include <queue>

using namespace std;
using ll = long long;
using ld = long double;
using ull = unsigned long long;
using uint = unsigned int;

constexpr ll inf = 1e18;

struct node {
	ll t;
	string s;
	ll l, i;

	node(ll _t, string _s, ll _l, ll _i) {
		t = _t, s = _s, l = _l, i = _i;
	}

	bool operator<(const node& x) const {
		if (t != x.t) return t < x.t;
		return i > x.i;
	}
};

void solve() {
	ll n; cin >> n;
	queue<pair<ll, string>> s1;
	for (ll i = 0; i < n; ++i) {
		ll t; string s; cin >> s >> t;
		s1.emplace(t, s);
	}
	set<node> s2;
	ll m; cin >> m;
	for(ll i = 0; i < m; ++i) {
		ll t, l;
		string s;
		cin >> t >> s >> l;
		s2.emplace(t, s, l, i);
	}
	ll timer = 0;
	while (!s1.empty() || !s2.empty()) {
		if ((s2.empty() || timer < s2.begin()->t) && !s1.empty()) {
			cout << s1.front().second << " " << timer << "\n";
			timer += s1.front().first;
			s1.pop();
		}
		else {
			timer = max(timer, s2.begin()->t);
			cout << s2.begin()->s << " " << timer << "\n";
			timer += s2.begin()->l;
			s2.erase(s2.begin());
		}
	}
}

signed main() {
	ios::sync_with_stdio(false);
	cin.tie(nullptr);
	ll tt = 1;
	//cin >> tt;
	while (tt--) solve();
	return 0;
}