#include <iostream>
#include <algorithm>
#include <cmath>
#include <string>
#include <iomanip>
#include <map>
#include <set>
#include <vector>
#include <unordered_map>
#include <unordered_set>
#include <cassert>

using namespace std;
using ll = long long;
using ld = long double;
using ull = unsigned long long;
using uint = unsigned int;

constexpr ll inf = 1e18;

struct segtree {
	struct node {
		ll p_p, p_n, s_p, s_n, ans, sz;
		std::pair<ll, ll> p_ans, s_ans;

		node() = default;
	};

	vector<node> t;

	segtree(const vector<ll>& fck) {
		t.resize(4 * fck.size());
		build(fck, 0, 0, fck.size());
	}

	node relax(node a, node b) {
		node res;
		res.sz = a.sz + b.sz;
		if (a.p_p == a.sz) {
			res.p_p = a.sz + b.p_p;
			if (b.p_ans.second != 0) {
				res.p_ans.first = a.sz + b.p_ans.first;
				res.p_ans.second = b.p_ans.second;
			}
		}
		else {
			res.p_p = a.p_p;
			res.p_ans = a.p_ans;
		}
		if (a.p_n == a.sz) {
			res.p_n = a.sz + b.p_n;
		}
		else {
			res.p_n = a.p_n;
		}
		if (b.s_p == b.sz) {
			res.s_p = b.sz + a.s_p;
			if (a.s_ans.first != 0) {
				res.s_ans.first = a.s_ans.first;
				res.s_ans.second = a.s_ans.second + b.sz;
			}
		}
		else {
			res.s_p = b.s_p;
			res.s_ans = b.s_ans;
		}
		if (b.s_n == b.sz) {
			res.s_n = b.sz + a.s_n;
		}
		else {
			res.s_n = b.s_n;
		}
		res.ans = a.ans;
		res.ans = std::max(res.ans, b.ans);
		res.ans = std::max(res.ans, 2 * std::min(a.s_p, b.p_n));
		res.ans = std::max(res.ans, 2 * std::min(b.p_ans.second, b.p_ans.first + a.s_p));
		res.ans = std::max(res.ans, 2 * std::min(a.s_ans.first, a.s_ans.second + b.p_n));
		return res;
	}

	void build(const vector<ll>& fck, ll v, ll l, ll r) {
		if (r - l == 1) {
			t[v].sz = 1;
			if (fck[l] == 1) {
				t[v].p_p = 1;
				t[v].s_p = 1;
			}
			else if (fck[l] == -1) {
				t[v].p_n = 1;
				t[v].s_n = 1;
			}
			return;
		}
		ll m = (l + r) / 2;
		build(fck, 2 * v + 1, l, m);
		build(fck, 2 * v + 2, m, r);
		t[v] = relax(t[2 * v + 1], t[2 * v + 2]);
	}

	void update(ll v, ll l, ll r, ll i, ll x) {
		if (r - l == 1) {
			if (x == 1) {
				t[v].s_n = t[v].p_n = 0;
				t[v].p_p = 1;
				t[v].s_p = 1;
			}
			else if (x == -1) {
				t[v].p_p = t[v].s_p = 0;
				t[v].p_n = 1;
				t[v].s_n = 1;
			}
			else {
				t[v].p_p = t[v].s_p = t[v].p_n = t[v].s_n = 0;
			}
			return;
		}
		ll m = (l + r) / 2;
		if (i < m) {
			update(2 * v + 1, l, m, i, x);
		}
		else {
			update(2 * v + 2, m, r, i, x);
		}
		t[v] = relax(t[2 * v + 1], t[2 * v + 2]);
	}

	void update(ll i, ll x) {
		update(0, 0, t.size() / 4, i, x);
	}
};

void solve() {
	int n;
	std::cin >> n;
	std::vector<ll> a(n), b(n - 1);
	for (auto& i : a) {
		std::cin >> i;
	}
	for (int i = 0; i < n - 1; ++i) {
		b[i] = a[i + 1] - a[i];
	}
	if (n == 1) {
		std::cout << "1\n";
		int q;
		std::cin >> q;
		while (q--) {
			std::cout << "1\n";
		}
		return;
	}
	segtree t(b);
	std::cout << t.t[0].ans + 1 << '\n';
	int q;
	std::cin >> q;
	while (q--) {
		int i, x;
		std::cin >> i >> x;
		--i;
		if (i == n - 1) {
			a[i] = x;
			b[i - 1] = a[i] - a[i - 1];
			t.update(i - 1, b[i - 1]);
		}
		else if (i == 0) {
			a[i] = x;
			b[0] = a[1] - a[0];
			t.update(0, b[0]);
		}
		else {
			a[i] = x;
			b[i - 1] = a[i] - a[i - 1];
			b[i] = a[i + 1] - a[i];
			t.update(i - 1, b[i - 1]);
			t.update(i, b[i]);
		}
		std::cout << t.t[0].ans + 1 << '\n';
	}
}

signed main() {
	ios::sync_with_stdio(false);
	cin.tie(nullptr);
	ll tt = 1;
	//cin >> tt;
	while (tt--) solve();
	return 0;
}