#include <iostream>
#include <vector>


using namespace std;
const long long inf = 1e12;
long long gcd(long long a, long long b) {
    if (a == 0) return b;
    return gcd(b % a, a);
}

void solve()
{
    int n, L, w = 3001;
    cin >> n >> L;
    vector <long long> x(n), c(n);
    for (int i = 0; i < n; ++i) cin >> x[i];
    for (int i = 0; i < n; ++i) cin >> c[i];

    vector <vector <long long>> dp(n, vector <long long> (w, inf));
    for (int i = 0; i < n; ++i) {
        dp[0][x[i]] = min(c[i], dp[0][x[i]]);
    }

    for (int i = 1; i < n; ++i) {
        for (int j = 0; j < w; ++j) dp[i][j] = dp[i - 1][j];
        for (int j = 0; j < w; ++j) {
            dp[i][gcd(j, x[i])] = min(dp[i][gcd(j, x[i])], dp[i][j] + c[i]);
        }
    }


    long long ans = inf;
    for (int i = 1; i < w; ++i) {
        if (L % i == 0) {
            ans = min(ans, dp[n - 1][i]);
        }
    }

    if (ans == inf) ans = -1;
    cout << ans << "\n";
}








int main() {
    //freopen("input.txt", "r", stdin);
    //freopen("output.txt", "w", stdout);
    int t; cin >> t; while (t--) {solve();} return 0;}
