#include <iostream>
#include <vector>

using namespace std;


struct segment_tree {
    vector <int> left_UP;
    vector <int> left_DOWN;
    vector <int> right_UP;
    vector <int> right_DOWN;
    vector <int> right_heap;
    vector <int> left_heap;
    vector <int> mx;
    vector <int> a;

    void update_node(int t, int l, int r) {
        if (r - l == 1) return;
        int m = (l + r) / 2;

        mx[t] = max(mx[t * 2 + 1], mx[t * 2 + 2]);

        if (a[m] - a[m - 1] == 1) {
            int k = left_DOWN[t * 2 + 2];
            mx[t] = max(mx[t], min(k + right_UP[t * 2 + 1], left_heap[t * 2 + 2] - k));
        }

        if (a[m - 1] - a[m] == 1) {
            int k = right_DOWN[t * 2 + 1];
            mx[t] = max(mx[t], min(k + left_UP[t * 2 + 2], right_heap[t * 2 + 1] - k));
        }

        left_DOWN[t] = left_DOWN[t * 2 + 1];
        left_UP[t] = left_UP[t * 2 + 1];
        right_DOWN[t] = right_DOWN[t * 2 + 2];
        right_UP[t] = right_UP[t * 2 + 2];

        if (a[m] - a[m - 1] == 1 && left_DOWN[t * 2 + 1] == m - l) {
            left_DOWN[t] += left_DOWN[t * 2 + 2];
        }

        if (a[m - 1] - a[m] == 1 && left_UP[t * 2 + 1] == m - l) {
            left_UP[t] += left_UP[t * 2 + 2];
        }

        if (a[m - 1] - a[m] == 1 && right_DOWN[t * 2 + 2] == r - m) {
            right_DOWN[t] += right_DOWN[t * 2 + 1];
        }

        if (a[m] - a[m - 1] == 1 && right_UP[t * 2 + 2] == r - m) {
            right_UP[t] += right_UP[t * 2 + 1];
        }

        left_heap[t] = left_heap[t * 2 + 1];
        if (a[m - 1] - a[m] == 1 && left_heap[t * 2 + 1] == m - l) {
            left_heap[t] += left_UP[t * 2 + 2];
        }
        if (a[m] - a[m - 1] == 1 && left_DOWN[t * 2 + 1] == m - l) {
            left_heap[t] = max(left_heap[t], left_DOWN[t * 2 + 1] + left_heap[t * 2 + 2]);
        }



        right_heap[t] = right_heap[t * 2 + 2];
        if (a[m] - a[m - 1] == 1 && right_heap[t * 2 + 2] == r - m) {
            right_heap[t] += right_UP[t * 2 + 1];
        }
        if (a[m - 1] - a[m] == 1 && right_DOWN[t * 2 + 2] == r - m) {
            right_heap[t] = max(right_heap[t], right_DOWN[t * 2 + 2] + right_heap[t * 2 + 1]);
        }
    }

    void build(int t, int l, int r) {
        if (r - l == 1) {
            left_DOWN[t] = 1;
            left_UP[t] = 1;
            left_heap[t] = 1;
            right_DOWN[t] = 1;
            right_UP[t] = 1;
            right_heap[t] = 1;
            mx[t] = 1;
            return;
        }
        int m = (l + r) / 2;
        build(t * 2 + 1, l, m);
        build(t * 2 + 2, m, r);
        update_node(t, l, r);
    }

    void change(int t, int l, int r, int i, int x) {
        if (r - l == 1) {
            a[l] = x;
            return;
        }
        int m = (l + r) / 2;
        if (i < m) {
            change(t * 2 + 1, l, m, i, x);
        } else {
            change(t * 2 + 2, m, r, i, x);
        }
        update_node(t, l, r);
    }


    int get() {
        return mx[0];
    }

    void change(int i, int x) {
        change(0, 0, a.size(), i, x);
    }

    segment_tree(vector <int> v): a(v) {
        int n = a.size();
        left_DOWN.resize(4 * n + 1, 0);
        left_heap.resize(4 * n + 1, 0);
        left_UP.resize(4 * n + 1, 0);
        right_DOWN.resize(4 * n + 1, 0);
        right_heap.resize(4 * n + 1, 0);
        right_UP.resize(4 * n + 1, 0);
        build(0, 0, a.size());
    }
};
int main()
{
    int n;
    cin >> n;
    vector <int> v(n);
    for (int i = 0; i < n; ++i) cin >> v[i];

    int q;
    cin >> q;
    segment_tree tree(v);
    cout << tree.get() << "\n";
    while (q--) {
        int i, x;
        cin >> i >> x; i--;
        tree.change(i, x);
        cout << tree.get() << "\n";
    }
    return 0;
}
