#include <ext/pb_ds/assoc_container.hpp>
#include <bits/stdc++.h>

using namespace std;

#define sz(x) (ll) x.size()
#define all(x) x.begin(), x.end()
typedef unsigned long long ull;
typedef long long ll;

const int k = 40;
double r;
double al, ar, bl, br, cl, cr;

const double pi = 2 * asin(1);

struct vct {
    double x, y;

    vct(double alp) {
        x = cos(alp) * r;
        y = sin(alp) * r;
    }

    vct(double x_, double y_) {
        x = x_;
        y = y_;
    }


    vct operator-(vct b) {
        return vct(x - b.x, y - b.y);
    }
};

double cross(vct a, vct b) {
    return a.x * b.y - a.y * b.x;
}

double area(double alp, double bet, double gam) {;
    vct a(alp), b(bet), c(gam);
    vct ab = a - b, bc = b - c;
    return abs(cross(ab, bc));
}

double getC(double a, double b) {
    double l = cl, r = cr;

    for (int i = 0; i < k; ++i) {
        double m1 = l + (r - l) / 3, m2 = r - (r - l) / 3;

        double s1 = area(a, b, m1), s2 = area(a, b, m2);
        if (s1 == s2) {
            l = m1;
            r = m2;
        } else if (s1 > s2) {
            r = m2;
        } else {
            l = m1;
        }
    }

    return l;
}

pair<double, double> getB(double a) {
    double l = bl, r = br;

    for (int i = 0; i < k; ++i) {
        double m1 = l + (r - l) / 3, m2 = r - (r - l) / 3;
        double c1 = getC(a, m1), c2 =- getC(a, m2);;

        double s1 = area(a, m1, c1), s2 = area(a, m2, c2);
        if (s1 == s2) {
            l = m1;
            r = m2;
        } else if (s1 > s2) {
            r = m2;
        } else {
            l = m1;
        }
    }

    return {l, getC(a, l)};
}

double getA() {
    double l = al, r = ar;

    for (int i = 0; i < k; ++i) {
        double m1 = l + (r - l) / 3, m2 = r - (r - l) / 3;
        auto [c1, b1] = getB(m1);
        auto [c2, b2] = getB(m2);

        double s1 = area(m1, b1, c1), s2 = area(m2, b2, c2);
        if (s1 == s2) {
            l = m1;
            r = m2;
        } else if (s1 > s2) {
            r = m2;
        } else {
            l = m1;
        }
    }

    auto [b, c] = getB(l);
    return area(l, b, c);
}

void solve() {
    cin >> r;
    double ali, ari, bli, bri, cli, cri;
    cin >> ali >> ari >> bli >> bri >> cli >> cri;
    double ans = -1;
    al = ali;
    ar = ari;
    bl = bli;
    br = bri;
    cl = cli;
    cr = cri;
    vector<pair<double, double>> v = {{al, ar}, {bl, br}, {cl, cr}};
    sort(v.begin(), v.end());

    do {
        al = v[0].first;
        ar = v[0].second;
        bl = v[1].first;
        br = v[1].second;
        cl = v[2].first;
        cr = v[2].second;
        // cout << al << ' ' << bl << ' ' << cl << '\n';

        double res = getA();
        // cout << res << '\n';
        ans = max(res, ans);
    } while (next_permutation(v.begin(), v.end()));

    //cout << pi<< "\n";
    // cout << area(pi / 3, 2 * pi / 3, 4 * pi / 3) / 2;

    cout << fixed << setprecision(9) << ans / 2;
}

int main() {
    // ios::sync_with_stdio(false);
    // cin.tie(nullptr);
    // cout.tie(nullptr);
    ll t = 1;

    while (t--) {
        solve();
        cout << '\n';
    }

    return 0;
}