#include <bits/stdc++.h>
using namespace std;

using int64 = long long;
const int64 MOD = 998244353;

inline int64 addmod(int64 a, int64 b) {
    a += b;
    if (a >= MOD) a -= MOD;
    return a;
}

inline int64 submod(int64 a, int64 b) {
    a -= b;
    if (a < 0) a += MOD;
    return a;
}

inline int64 mulmod(int64 a, int64 b) {
    return (a % MOD) * (b % MOD) % MOD;
}

int64 sum1(int64 L, int64 R) {
    if (L > R) return 0;
    int64 n = (R - L + 1) % MOD;
    int64 s = (L + R) % MOD;
    return mulmod(mulmod(n, s), (MOD + 1) / 2);
}

int64 sum2(int64 L, int64 R) {
    auto f = [&](int64 x) -> int64 {
        if (x < 0) return 0;
        x %= MOD;
        int64 a = x;
        int64 b = (x + 1) % MOD;
        int64 c = (2 * x + 1) % MOD;
        int64 res = mulmod(a, mulmod(b, c));
        return mulmod(res, (MOD + 1) / 6);
    };
    return submod(f(R), f(L - 1));
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int64 n;
    cin >> n;

    int64 ans = 0;

    int64 j = 1;
    while (j <= n) {
        int64 q = n / j;
        int64 r = n / q;
        if (r > n) r = n;

        int64 S1 = sum1(j, r);
        int64 S2 = sum2(j, r);
        int64 term1 = submod(S2, S1);
        term1 = mulmod(term1, (MOD + 1) / 2);
        term1 = mulmod(term1, q % MOD);

        int64 A = n % MOD;
        int64 Q = q % MOD;
        int64 cnt = (r - j + 1) % MOD;

        int64 sum_rem = submod(mulmod(cnt, A), mulmod(Q, S1));

        int64 n2 = mulmod(A, A);
        int64 q2 = mulmod(Q, Q);
        int64 sum_rem2 = 0;
        sum_rem2 = addmod(sum_rem2, mulmod(cnt, n2));
        sum_rem2 = submod(sum_rem2, mulmod(mulmod(2, A), mulmod(Q, S1)));
        sum_rem2 = addmod(sum_rem2, mulmod(q2, S2));

        int64 term2 = addmod(sum_rem2, sum_rem);
        term2 = mulmod(term2, (MOD + 1) / 2);

        ans = addmod(ans, addmod(term1, term2));

        j = r + 1;
    }

    cout << ans << '\n';
    return 0;
}