from collections import deque
import sys

input = sys.stdin.readline

n = int(input())
queue = deque()
for _ in range(n):
    name, length = input().split()
    length = int(length)
    queue.append((name, length))

m = int(input())
events = []
for _ in range(m):
    t, namen, length = input().split()
    t = int(t)
    length = int(length)
    events.append((t, name, length))

current_time = 0
result = []
event_index = 0

while queue or event_index < len (events):
    if not queue:
        t_next, name_next, len_next = events[event_index]
        current_time = t_next
        queue.appendleft((name_next, len_next))
        event_index += 1

    name, length = queue.popleft()
    start_time = current_time
    end_time = current_time + length

    while event_index < len(events) and events[event_index][0] <= end_time:
        t_new, name_new, len_new = events[event_index]
        queue.appendleft((name_new, len_new))
        event_index += 1

    result.append((name, start_time))
    current_time = end_time

for name, start in result:
    print(name, result)
