#include <iostream>
#include <vector>
#include <climits>
#include <algorithm>

using namespace std;

int main() {
    int n;
    cin >> n;
    vector<int> a(n);
    for (int i = 0; i < n; ++i) {
        cin >> a[i];
    }

    // Create a vector of pairs (value, original_index)
    vector<pair<int, int>> indexed_a(n);
    for (int i = 0; i < n; ++i) {
        indexed_a[i] = {a[i], i};
    }

    // Sort based on values
    sort(indexed_a.begin(), indexed_a.end());

    // Create a mapping from original index to new sorted index
    vector<int> pos(n);
    for (int i = 0; i < n; ++i) {
        pos[indexed_a[i].second] = i;
    }

    int max_len = 1;
    int current_len = 1;

    for (int i = 1; i < n; ++i) {
        if (pos[i] > pos[i - 1]) {
            current_len++;
            max_len = max(max_len, current_len);
        } else {
            current_len = 1;
        }
    }

    cout << max_len << endl;

    return 0;
}