import sys
import threading
def main():
    import sys
    sys.setrecursionlimit(10**7)
    from math import gcd

    MOD = 998244353
    input = sys.stdin.readline

    n = int(input())
    a = [0] + list(map(int, input().split())) + [0]

    GL = [0] * (n + 2)
    GR = [0] * (n + 2)

    # Префиксные gcd
    for i in range(1, n + 1):
        GL[i] = gcd(GL[i-1], a[i])

    # Суффиксные gcd
    for i in range(n, 0, -1):
        GR[i] = gcd(GR[i+1], a[i])

    ans = 0

    # Для каждой левой границы i считаем gcd-сегменты
    for i in range(1, n + 1):
        L = GL[i-1]

        # Собираем gcd-блоки на отрезке [i..j]
        segs = []
        cur_g = a[i]
        start = i
        for j in range(i, n + 1):
            new_g = gcd(cur_g, a[j])
            if new_g != cur_g:
                segs.append((cur_g, start, j - 1))
                cur_g = new_g
                start = j
        segs.append((cur_g, start, n))

        # Для каждого блока пересекаем с gcd-ступенями справа
        for G, jl, jr in segs:
            pos = jl
            while pos <= jr:
                R = GR[pos + 1]

                # Найдём максимально правый rpos, где GR[j+1] == R
                low = pos
                high = jr
                while low < high:
                    mid = (low + high + 1) >> 1
                    if GR[mid + 1] == R:
                        low = mid
                    else:
                        high = mid - 1
                rpos = low

                X = gcd(L, R)
                val = gcd(G, X)

                ans = (ans + val * (rpos - pos + 1)) % MOD
                pos = rpos + 1

    print(ans % MOD)


threading.Thread(target=main).start()
