from collections import deque
import sys
input = sys.stdin.readline

n = int(input())
queue = deque()
for _ in range(n):
    name, length = input().split()
    queue.append((name, int(length)))

m = int(input())
events = []
for _ in range(m):
    t, name, length = input().split()
    events.append((int(t), name, int(length)))

current_time = 0
res = []
event_idx = 0

while queue or event_idx < m:
    if not queue:
        # Если очередь пуста, но есть события
        t, name, length = events[event_idx]
        current_time = max(current_time, t)
        queue.appendleft((name, length))
        event_idx += 1

    name, length = queue.popleft()
    start_time = current_time
    res.append((name, start_time))
    current_time += length

    # Добавляем все события, которые произошли до конца этой песни
    while event_idx < m and events[event_idx][0] <= current_time:
        t, ename, elen = events[event_idx]
        queue.appendleft((ename, elen))
        event_idx += 1

for name, start in res:
    print(name, start)
