import sys
import random
import math
input = sys.stdin.readline

# Miller-Rabin
def is_prime(n):
    if n < 2:
        return False
    small = [2,3,5,7,11,13,17,19,23,29]
    for p in small:
        if n % p == 0:
            return n == p
    d = n-1
    s = 0
    while d % 2 == 0:
        d//=2
        s+=1
    for a in [2,325,9375,28178,450775,9780504,1795265022]:
        if a % n == 0:
            continue
        x = pow(a, d, n)
        if x == 1 or x == n-1:
            continue
        for _ in range(s-1):
            x = (x*x)%n
            if x == n-1:
                break
        else:
            return False
    return True

# Pollard Rho
def f(x,c,n):
    return (x*x + c) % n

def pollard(n):
    if n%2==0:
        return 2
    if n%3==0:
        return 3
    while True:
        x = random.randrange(2,n-1)
        y = x
        c = random.randrange(1,n-1)
        d = 1
        while d == 1:
            x = f(x,c,n)
            y = f(f(y,c,n),c,n)
            d = math.gcd(abs(x-y),n)
        if d != n:
            return d

def factor(n, res):
    if n == 1:
        return
    if is_prime(n):
        res.append(n)
    else:
        d = pollard(n)
        factor(d,res)
        factor(n//d,res)

def omega(n):
    res=[]
    factor(n,res)
    return len(res)

# ------------ MAIN ----------------
t = int(input())
for _ in range(t):
    n = int(input())
    arr = list(map(int,input().split()))

    total = 0
    for x in arr:
        total += omega(x)

    # Петя выигрывает <=> total - n нечетно
    print("Yes" if ((total - n) % 2 == 1) else "No")
