import sys
import random

input = sys.stdin.readline

n = int(input())

if n == 1:
    print("Yes")
    print(1)
    exit()

if n == 2:
    
    print("No")
    exit()

def build_and_check():
    p = list(range(n))
    random.shuffle(p)

    
    row_sums = []
    col_sums = [0] * n

    diag1 = 0
    diag2 = 0

    for i in range(n):
        s = 0
        for j in range(n):
            val = i * n + p[j] + 1
            s += val
            col_sums[j] += val
        row_sums.append(s)
        diag1 += i * n + p[i] + 1
        diag2 += i * n + p[n - 1 - i] + 1

    all_sums = row_sums + col_sums + [diag1, diag2]

    if len(all_sums) == len(set(all_sums)):
        
        grid = [[i * n + p[j] + 1 for j in range(n)] for i in range(n)]
        return grid
    return None



for _ in range(20):
    res = build_and_check()
    if res is not None:
        print("Yes")
        for row in res:
            print(*row)
        break
else:
    
    print("No")
