#include <bits/stdc++.h>

using namespace std;

using ll = long long;

const ll mp = 30;

ll ppow(ll base, ll power) {
    if (power == 0) {
        return 1ll;
    }
    if (power & 1) {
        return pow(base, power / 2) * pow(base, power / 2) * base;
    } else {
        return pow(base, power / 2) * pow(base, power / 2);
    }
}

bitset<mp> convert(ll num) {
    bitset<mp> bs;
    ll pntr = 0;
    while (num > 0) {
        if (num & 1) {
            bs[pntr] = true;
        }
        num /= 2;
        ++pntr;
    }

    return bs;
}

ll convert_back(bitset<mp> bs) {
    ll res = 0;
    for (ll pwr = 0; pwr < mp; ++pwr) {
        if (bs[pwr]) {
            res += ppow(2, pwr);
        }
    }

    return res;
}

ll mmax(vector<ll>& v) {
    ll ans = LLONG_MIN;
    for (auto i : v) {
        if (i > ans) {
            ans = i;
        }
    }

    return ans;
}

int main() {
	ll t;
	cin >> t;
	for (ll iteration = 0ll; iteration < t; ++iteration) {
	    ll n;
	    cin >> n;
	    vector<ll> v(n);
	    for (ll i = 0ll; i < n; ++i) {
	        cin >> v[i];
	    }
	    if (n & 1) {
	        bitset<mp> ans;
            ans.set();
	        cout << convert_back(ans) << '\n';
	    } else {
    	    ll xor_p = 0ll;
    	    for (auto i : v) {
    	        xor_p = xor_p ^ i;
    	    }

    	    ll temp = -1;
    	    bitset<mp> xor_b = convert(xor_p);

    	    for (ll bit = 0; bit < mp; ++bit) {
    	        if (temp == -1) {
    	           if (xor_b[bit] == true) {
    	                temp = bit;
    	                xor_b[bit] = false;
    	            } else {
    	                xor_b[bit] = true;
    	            }
    	        } else {
    	            xor_b[bit] = true;
    	        }
    	    }

    	    if (temp == -1) {
    	        cout << -1 << "\n";
    	    } else {
    	        cout << convert_back(xor_b) << "\n";
    	    }
	    }
	}
}
