#include <bits/stdc++.h>
using namespace std;
using int64 = long long;
const int64 MOD = 998244353;

int64 modmul128(__int128 a, __int128 b){
    __int128 r = a * b;
    r %= MOD;
    if(r < 0) r += MOD;
    return (int64)r;
}
int64 modnorm(__int128 x){
    x %= MOD;
    if(x < 0) x += MOD;
    return (int64)x;
}
int64 addmod(int64 a, int64 b){ a += b; if(a >= MOD) a -= MOD; return a; }
int64 submod(int64 a, int64 b){ a -= b; if(a < 0) a += MOD; return a; }
int64 mulmod(int64 a, int64 b){ return (int64)((__int128)a * b % MOD); }
int64 powmod(int64 a, int64 e){
    int64 r = 1;
    while(e){
        if(e & 1) r = mulmod(r, a);
        a = mulmod(a, a);
        e >>= 1;
    }
    return r;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    long long n;
    if(!(cin >> n)) return 0;

    int64 inv2 = powmod(2, MOD-2);
    int64 inv6 = powmod(6, MOD-2);

    // helper: sum 1..k modulo
    auto sum1 = [&](long long k)->int64{
        if(k <= 0) return 0;
        int64 K = (k % MOD);
        int64 K1 = ((k+1) % MOD);
        return mulmod(mulmod(K, K1), inv2);
    };
    // helper: sum squares 1^2 + ... + k^2
    auto sum2 = [&](long long k)->int64{
        if(k <= 0) return 0;
        int64 K = (k % MOD);
        int64 K1 = ((k+1) % MOD);
        int64 K2 = ((2%MOD * K %MOD + 1)%MOD); // 2k+1 mod
        return mulmod(mulmod(mulmod(K, K1), K2), inv6);
    };

    // totalContribution = sum_{j=1..n} j * F(j)
    int64 totalContr = 0;

    long long j = 1;
    while(j <= n){
        long long m = n / j;
        long long R = n / m;
        long long L = j;
        // compute sum_j = sum_{t=L..R} t
        int64 sum_j = submod(sum1(R), sum1(L-1));
        // compute sum_j2 = sum_{t=L..R} t^2
        int64 sum_j2 = submod(sum2(R), sum2(L-1));
        // coeffs: -m(m+1)/2 * sum_j2  +  m*(n+1)*sum_j
        int64 mm = (m % MOD);
        int64 coeffA = mulmod(mm, ( (m+1) % MOD ));
        coeffA = mulmod(coeffA, inv2); // m(m+1)/2 mod
        // term1 = -coeffA * sum_j2
        int64 term1 = mulmod(coeffA, sum_j2);
        term1 = (term1 == 0 ? 0 : (MOD - term1)); // negate mod
        int64 term2 = mulmod(mm, (( (n+1) % MOD )));
        term2 = mulmod(term2, sum_j);
        int64 seg = addmod(term1, term2);
        totalContr = addmod(totalContr, seg);

        j = R + 1;
    }

    // first part: n * (n(n+1)/2)
    int64 nmod = (n % MOD);
    int64 part = mulmod(nmod, mulmod(nmod, ((n+1) % MOD)));
    part = mulmod(part, inv2);
    int64 ans = submod(part, totalContr);
    cout << ans << "\n";
    return 0;
}
