#include <bits/stdc++.h>
using namespace std;

struct HopcroftKarp {
    int nL, nR;
    vector<vector<int>> g;
    vector<int> dist, pairU, pairV;
    const int INF = 1e9;

    HopcroftKarp(int _nL = 0, int _nR = 0) { init(_nL, _nR); }
    void init(int _nL, int _nR) {
        nL = _nL; nR = _nR;
        g.assign(nL, {});
        pairU.assign(nL, -1);
        pairV.assign(nR, -1);
        dist.assign(nL, 0);
    }
    void addEdge(int u, int v) { // 0-based u in [0..nL-1], v in [0..nR-1]
        g[u].push_back(v);
    }
    bool bfs() {
        queue<int> q;
        for (int u = 0; u < nL; ++u) {
            if (pairU[u] == -1) { dist[u] = 0; q.push(u); }
            else dist[u] = INF;
        }
        bool reachableFree = false;
        while (!q.empty()) {
            int u = q.front(); q.pop();
            for (int v : g[u]) {
                int pu = pairV[v];
                if (pu != -1 && dist[pu] == INF) {
                    dist[pu] = dist[u] + 1;
                    q.push(pu);
                }
                if (pu == -1) reachableFree = true;
            }
        }
        return reachableFree;
    }
    bool dfs(int u) {
        for (int v : g[u]) {
            int pu = pairV[v];
            if (pu == -1 || (dist[pu] == dist[u] + 1 && dfs(pu))) {
                pairU[u] = v;
                pairV[v] = u;
                return true;
            }
        }
        dist[u] = INF;
        return false;
    }
    int maxMatching() {
        fill(pairU.begin(), pairU.end(), -1);
        fill(pairV.begin(), pairV.end(), -1);
        int matching = 0;
        while (bfs()) {
            for (int u = 0; u < nL; ++u)
                if (pairU[u] == -1 && dfs(u))
                    ++matching;
        }
        return matching;
    }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    if (!(cin >> n)) return 0;
    if (n == 1) {
        cout << "1\n";
        return 0;
    }
    if (n == 2) {
        cout << -1 << '\n';
        return 0;
    }

    // usedInCol[c][s] == true если символ s уже использован в колонке c (1-based indices)
    vector<vector<char>> used(n+1, vector<char>(n+1, 0));
    vector<vector<int>> A(n+1, vector<int>(n+1, 0)); // 1-based

    for (int i = 1; i <= n; ++i) {
        // we must set A[i][i] = i, check availability
        if (used[i][i]) { cout << -1 << '\n'; return 0; }
        A[i][i] = i;
        used[i][i] = 1;

        // build bipartite graph between columns C = {j | j!=i} and symbols S = {s | s!=i}
        // index left: map columns->0..L-1, right: symbols->0..R-1
        vector<int> cols; cols.reserve(n-1);
        vector<int> syms; syms.reserve(n-1);
        vector<int> colId(n+1, -1), symId(n+1, -1);
        for (int j = 1; j <= n; ++j) if (j != i) { colId[j] = (int)cols.size(); cols.push_back(j); }
        for (int s = 1; s <= n; ++s) if (s != i) { symId[s] = (int)syms.size(); syms.push_back(s); }

        int L = (int)cols.size(), R = (int)syms.size();
        HopcroftKarp hk(L, R);
        for (int idxC = 0; idxC < L; ++idxC) {
            int c = cols[idxC];
            for (int idxS = 0; idxS < R; ++idxS) {
                int s = syms[idxS];
                if (!used[c][s]) hk.addEdge(idxC, idxS);
            }
        }
        int need = L; // n-1
        int matching = hk.maxMatching();
        if (matching < need) {
            cout << -1 << '\n';
            return 0;
        }
        // hk.pairU maps left idx -> right idx
        for (int idxC = 0; idxC < L; ++idxC) {
            int idxS = hk.pairU[idxC];
            int c = cols[idxC];
            int s = syms[idxS];
            A[i][c] = s;
            used[c][s] = 1;
        }
    }

    // print matrix
    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= n; ++j) {
            if (j > 1) cout << ' ';
            cout << A[i][j];
        }
        cout << '\n';
    }
    return 0;
}
