#include <bits/stdc++.h>
using namespace std;
using ll = long long;

struct Run {
    int L, R; // inclusive indices in d-array (1..n-1)
    int type; // -1, 0, 1
    int len() const { return R - L + 1; }
};

int n;
vector<ll> a; // 1..n
vector<int> t; // 1..n-1 : -1,0,1

map<int, Run> runs; // key = L
multiset<int> cand;  // candidate palindrome lengths (2*min(lenLeft,lenRight)+1) for adj pairs (1 then -1)

int makeTypeAtD(int idx){ // idx in [1..n-1]
    if(idx < 1 || idx >= n) return 0;
    ll diff = a[idx+1] - a[idx];
    if(diff == 1) return 1;
    if(diff == -1) return -1;
    return 0;
}

auto findRunContaining(int idx)->map<int,Run>::iterator{
    auto it = runs.upper_bound(idx);
    if(it == runs.begin()) return runs.end();
    --it;
    if(it->second.L <= idx && idx <= it->second.R) return it;
    return runs.end();
}

void removeBoundaryCandidate(map<int,Run>::iterator itL, map<int,Run>::iterator itR){
    if(itL==runs.end() || itR==runs.end()) return;
    if(itL->second.type == 1 && itR->second.type == -1){
        int v = 2 * min(itL->second.len(), itR->second.len()) + 1;
        auto it = cand.find(v);
        if(it != cand.end()) cand.erase(it);
    }
}

void addBoundaryCandidate(map<int,Run>::iterator itL, map<int,Run>::iterator itR){
    if(itL==runs.end() || itR==runs.end()) return;
    if(itL->second.type == 1 && itR->second.type == -1){
        int v = 2 * min(itL->second.len(), itR->second.len()) + 1;
        cand.insert(v);
    }
}

void insertRunWithMerge(vector<Run> &segs, int oldL, int oldR){
    // prevRun = run whose start < oldL and maximum possible (or end up = runs.end())
    auto itPrev = runs.upper_bound(oldL);
    if(itPrev != runs.begin()) --itPrev;
    else itPrev = runs.end();

    // Insert each segment, merging with previous if same type
    map<int,Run>::iterator lastInserted = runs.end();
    for(auto &seg : segs){
        if(seg.L > seg.R) continue;
        if(itPrev != runs.end() && itPrev->second.type == seg.type && itPrev->second.R + 1 == seg.L){
            // merge into prev
            itPrev->second.R = seg.R;
            // lastInserted becomes itPrev
            lastInserted = itPrev;
        } else {
            // insert new run
            Run nr = seg;
            auto p = runs.emplace(nr.L, nr).first;
            lastInserted = p;
            itPrev = p;
        }
    }
    // After insertion/merge, we need to add candidates for adjacencies in neighborhood [oldL-1, oldR+1]
    // Find first run whose R >= oldL-1 (or whose L >= oldL-1)
    auto itStart = runs.upper_bound(max(1, oldL-1));
    if(itStart != runs.begin()) --itStart; // now itStart is candidate to start from
    // iterate while start.L <= oldR+1
    vector<map<int,Run>::iterator> touched;
    for(auto it = itStart; it != runs.end(); ++it){
        if(it->second.L > oldR + 1) break;
        touched.push_back(it);
    }
    // add boundary candidates between consecutive touched runs and with neighbors outside touched region
    if(!touched.empty()){
        // with predecessor
        auto itPre = touched.front();
        if(itPre != runs.begin()){
            auto prevIt = itPre; --prevIt;
            addBoundaryCandidate(prevIt, itPre);
        }
        for(size_t k=0;k+1<touched.size();++k){
            addBoundaryCandidate(touched[k], touched[k+1]);
        }
        // with successor
        auto itLast = touched.back();
        auto nextIt = itLast; ++nextIt;
        if(nextIt != runs.end()){
            addBoundaryCandidate(itLast, nextIt);
        }
    } else {
        // nothing in range, but maybe boundary between prev and next changed:
        // check neighbor around oldL
        auto itL = runs.upper_bound(oldL);
        if(itL != runs.begin()){
            auto prevIt = itL; --prevIt;
            addBoundaryCandidate(prevIt, itL);
        }
    }
}

void setTypeAtIndex(int idx, int newType){
    if(idx < 1 || idx >= n) return;
    // find run containing idx
    auto itOld = findRunContaining(idx);
    if(itOld == runs.end()){
        // shouldn't happen if runs cover entire [1..n-1], but handle creating singletons
        vector<Run> segs;
        segs.push_back({idx, idx, newType});
        insertRunWithMerge(segs, idx, idx);
        return;
    }
    Run old = itOld->second;
    int oldL = old.L, oldR = old.R;
    // remove adjacent boundary candidates that involve old run
    map<int,Run>::iterator prevIt = itOld, nextIt = itOld;
    if(itOld != runs.begin()){
        --prevIt;
        removeBoundaryCandidate(prevIt, itOld);
    } else prevIt = runs.end();
    nextIt++;
    if(nextIt != runs.end()){
        removeBoundaryCandidate(itOld, nextIt);
    } else nextIt = runs.end();

    // erase old run
    runs.erase(itOld);

    // build new segments after changing index idx to newType
    vector<Run> segs;
    if(oldL <= idx-1) segs.push_back({oldL, idx-1, old.type});
    segs.push_back({idx, idx, newType});
    if(idx+1 <= oldR) segs.push_back({idx+1, oldR, old.type});

    // insert segments with merging
    insertRunWithMerge(segs, oldL, oldR);
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int q;
    if(!(cin >> n)) return 0;
    a.assign(n+1,0);
    for(int i=1;i<=n;i++) cin >> a[i];
    cin >> q;
    vector<pair<int,ll>> queries(q);
    for(int i=0;i<q;i++){
        cin >> queries[i].first >> queries[i].second;
    }

    if(n == 1){
        // always length 1
        cout << 1 << '\n';
        for(int i=0;i<q;i++) cout << 1 << '\n';
        return 0;
    }

    // build t[1..n-1]
    t.assign(n, 0);
    for(int i=1;i<=n-1;i++) t[i] = makeTypeAtD(i);

    // build runs
    runs.clear();
    cand.clear();
    int i = 1;
    while(i <= n-1){
        int j = i;
        int tp = t[i];
        while(j+1 <= n-1 && t[j+1] == tp) ++j;
        runs.emplace(i, Run{i,j,tp});
        i = j+1;
    }
    // fill candidate multiset for adj pairs (1 then -1)
    if(!runs.empty()){
        auto it = runs.begin();
        auto prev = it;
        ++it;
        for(; it != runs.end(); ++it){
            if(prev->second.type == 1 && it->second.type == -1){
                int v = 2 * min(prev->second.len(), it->second.len()) + 1;
                cand.insert(v);
            }
            prev = it;
        }
    }

    auto getAns = [&]()->int{
        if(cand.empty()) return 1;
        return max(1, *cand.rbegin());
    };

    // initial answer
    cout << getAns() << '\n';

    // process queries
    for(auto &qr : queries){
        int pos = qr.first;
        ll val = qr.second;
        // update a[pos] then update t at pos-1 and pos
        a[pos] = val;
        int newt;
        // idx = pos-1
        newt = makeTypeAtD(pos-1);
        setTypeAtIndex(pos-1, newt);
        // idx = pos
        newt = makeTypeAtD(pos);
        setTypeAtIndex(pos, newt);

        cout << getAns() << '\n';
    }
    return 0;
}
