import sys
input = sys.stdin.readline
from collections import deque

n = int(input())

queue = deque()
for _ in range(n):
    name, length = input().split()
    queue.append([name, int(length)])

m = int(input())
events = []
for _ in range(m):
    t, name, length = input().split()
    events.append((int(t), name, int(length)))

result = []
current_time = 0
event_index = 0

while queue or event_index < m:

    if not queue:
        t, new_name, new_len = events[event_index]
        current_time = t
        queue.appendleft([new_name, new_len])
        event_index += 1
        continue

    name, length = queue[0]
    start_time = current_time
    finish_time = start_time + length

    if event_index < m and events[event_index][0] < finish_time:
        t, new_name, new_len = events[event_index]
        queue[0][1] = finish_time - t      
        queue.appendleft([new_name, new_len])  
        current_time = t
        event_index += 1
    else:
        queue.popleft()
        result.append((name, start_time))
        current_time = finish_time


for name, st in result:
    print(name, st)
