import sys

def find_max_stepped_palindrome(arr):
    n = len(arr)
    if n == 0: return 0
    max_len = 1
    
    for i in range(n):
        current_len, height = 1, arr[i]
        k = 1
        while i - k >= 0 and i + k < n:
            expected_height = height - k
            if expected_height < 1: break
            if arr[i - k] == expected_height and arr[i + k] == expected_height:
                current_len += 2
                k += 1
            else:
                break
        max_len = max(max_len, current_len)

    for i in range(n - 1):
        if arr[i] == arr[i+1]:
            current_len, height = 2, arr[i]
            k = 1
            while i - k >= 0 and i + 1 + k < n:
                expected_height = height - k
                if expected_height < 1: break
                if arr[i - k] == expected_height and arr[i + 1 + k] == expected_height:
                    current_len += 2
                    k += 1
                else:
                    break
            max_len = max(max_len, current_len)
            
    return max_len

def solve():
    try:
        data = sys.stdin.readline().split()
        if not data: return
        N, Q = int(data[0]), int(data[1])
        A = list(map(int, sys.stdin.readline().split()))
    except: return
    
    print(find_max_stepped_palindrome(A))
    
    for _ in range(Q):
        try:
            line = sys.stdin.readline()
            if not line: break
            i, x = map(int, line.split())
        except: break

        A[i - 1] = x
        print(find_max_stepped_palindrome(A))

if __name__ == "__main__":
    solve()
