import sys
import math

# Задача C. Объединение амулетов
# Наивный O(n^2) вариант - подходит только для малых данных
# Для больших входных данных требуется оптимизированное решение.

input = sys.stdin.readline
MOD = 998244353

def main():
    n_line = input().strip()
    if not n_line:
        return
    n = int(n_line)
    a = list(map(int, input().split()))

    # Префиксные и суффиксные НОД
    pref = [0] * (n + 2)
    for i in range(1, n + 1):
        pref[i] = math.gcd(pref[i - 1], a[i - 1])

    suf = [0] * (n + 2)
    for i in range(n, 0, -1):
        suf[i] = math.gcd(suf[i + 1], a[i - 1])

    ans = 0

    for i in range(1, n + 1):
        cur_lcm = 1
        left_gcd = pref[i - 1]
        for j in range(i, n + 1):
            cur_lcm = cur_lcm * a[j - 1] // math.gcd(cur_lcm, a[j - 1])
            right_gcd = suf[j + 1]
            g = math.gcd(left_gcd, math.gcd(cur_lcm, right_gcd))
            ans = (ans + g) % MOD

    print(ans % MOD)

if __name__ == "__main__":
    main()
