import sys

def find_max_palindromic_length(arr, n):
    if n == 0:
        return 0
    
    max_len = 1
    
    for i in range(n):
        L = 0
        while i - L >= 0 and i + L < n and arr[i - L] == arr[i + L]:
            is_left_valid = True
            if L > 0 and arr[i - L] > arr[i - L + 1]:
                is_left_valid = False
            
            is_right_valid = True
            if L > 0 and arr[i + L - 1] < arr[i + L]:
                is_right_valid = False

            if is_left_valid and is_right_valid:
                 L += 1
            else:
                break
        
        max_len = max(max_len, 2 * (L - 1) + 1)

    return max_len

def solve():
    # --- БЛОК ЧТЕНИЯ ДАННЫХ ИЗ STDIN (Терминала) ---
    try:
        # Читаем все данные и разбиваем на список слов
        input_data = sys.stdin.read().split()
        
        if not input_data:
            return

        # 1. Чтение N
        N = int(input_data[0])
        
        # 2. Чтение массива A (N чисел после N)
        A = [int(x) for x in input_data[1:N+1]]
        
        # 3. Чтение Q
        Q_start_index = N + 1
        Q = int(input_data[Q_start_index])
        
        # 4. Чтение запросов (Q пар чисел)
        queries = []
        current_index = Q_start_index + 1
        for _ in range(Q):
            i = int(input_data[current_index])
            x = int(input_data[current_index + 1])
            queries.append((i, x))
            current_index += 2
            
    except Exception:
        return
    # -----------------------------------------------
    
    results = []
    
    # 1. Начальное состояние
    results.append(find_max_palindromic_length(A, N))
    
    # 2. Обработка запросов
    for i_query, x_query in queries:
        # Индекс в массиве A (1-based -> 0-based)
        index = i_query - 1
        A[index] = x_query
        
        # Пересчёт максимальной длины
        max_len = find_max_palindromic_length(A, N)
        results.append(max_len)

    sys.stdout.write('\n'.join(map(str, results)) + '\n')

if __name__ == "__main__":
    solve()