iimport sys

def solve():
    try:
        input = sys.stdin.read
        data = input().split()
        
        if not data:
            return

        N = int(data[0])
        A = [int(x) for x in data[1:N+1]]
        
        Q_start_index = N + 1
        Q = int(data[Q_start_index])
        
        queries = []
        current_index = Q_start_index + 1
        for _ in range(Q):
            i = int(data[current_index])
            x = int(data[current_index + 1])
            queries.append((i, x))
            current_index += 2
            
    except Exception:
        return
    
    def find_max_palindromic_length(arr, n):
        if n == 0:
            return 0
        
        max_len = 1
        
        for i in range(n):
            L = 0
            while i - L >= 0 and i + L < n and arr[i - L] == arr[i + L]:
                is_left_valid = True
                if L > 0 and arr[i - L] > arr[i - L + 1]:
                    is_left_valid = False
                
                is_right_valid = True
                if L > 0 and arr[i + L - 1] < arr[i + L]:
                    is_right_valid = False

                if is_left_valid and is_right_valid:
                     L += 1
                else:
                    break
            
            max_len = max(max_len, 2 * (L - 1) + 1)

        return max_len

    results = []
    
    results.append(find_max_palindromic_length(A, N))
    
    for i_query, x_query in queries:
        index = i_query - 1
        A[index] = x_query
        max_len = find_max_palindromic_length(A, N)
        results.append(max_len)

    sys.stdout.write('\n'.join(map(str, results)) + '\n')

if __name__ == "__main__":
    solve()