import sys

MOD = 998_244_353


def sum_range(a: int, b: int) -> int:
    cnt = b - a + 1
    return (a + b) * cnt // 2


def sum_sq_range(a: int, b: int) -> int:
    def f(x: int) -> int:
        return x * (x + 1) * (2 * x + 1) // 6

    return f(b) - f(a - 1)


def solve() -> None:
    data = sys.stdin.read().strip()
    if not data:
        return
    n = int(data)
    res = 0
    j = 1
    while j <= n:
        q = n // j
        b = n // q
        s1 = sum_range(j, b)
        s2 = sum_sq_range(j, b)
        cnt = b - j + 1

        term1 = (q * (s2 - s1)) // 2
        term2_num = cnt * n * (n + 1) - (2 * n + 1) * q * s1 + (q * q) * s2
        term2 = term2_num // 2

        res = (res + term1 + term2) % MOD
        j = b + 1

    print(res % MOD)


if __name__ == "__main__":
    solve()
