import math
import sys


def solve() -> None:
    data = sys.stdin.buffer.read().split()
    if not data:
        return
    it = iter(data)
    t = int(next(it))
    out_lines = []
    for _ in range(t):
        n = int(next(it))
        target = abs(int(next(it)))
        lengths = [int(next(it)) for _ in range(n)]
        costs = [int(next(it)) for _ in range(n)]
        dp: dict[int, int] = {}
        INF = 10**19
        for x, c in zip(lengths, costs):
            temp: dict[int, int] = {}
            if c < temp.get(x, INF):
                temp[x] = c
            for g, val in dp.items():
                new_g = math.gcd(g, x)
                new_cost = val + c
                if new_cost < temp.get(new_g, INF):
                    temp[new_g] = new_cost
            for g, val in temp.items():
                if val < dp.get(g, INF):
                    dp[g] = val
        if target == 0:
            best = min(dp.values(), default=INF)
            out_lines.append(str(best if best != INF else -1))
            continue

        best = INF
        for g, val in dp.items():
            if target % g == 0 and val < best:
                best = val
        out_lines.append(str(best if best != INF else -1))
    sys.stdout.write("\n".join(out_lines))


if __name__ == "__main__":
    solve()
